(* prof-control.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *
 * User interface for controling profiling.
 *)

signature PROFILE =
  sig
    datatype mode
      = NOPROF		(* no profiling *)
      | LATENT		(* compile code for profiling, do call counts *)
      | ACTIVE		(* LATENT + do timings *)

    val setMode : mode -> unit
    val getMode : unit -> mode

    val reset : unit -> unit          (* reset profiling counts to zero *)

    val report : TextIO.outstream -> unit
	  (* print profiling report to stream *)
    val reportAll : TextIO.outstream -> unit
	  (* print profiling report to stream; DON'T suppress zero entries*)
    val reportData: unit -> {name: string, count: int, time: Time.time} list
	  (* Return the unformatted data for a report *)

  end;


functor ProfileFn (ProfEnv: PROF_ENV) : PROFILE =
  struct

    open Profile

    datatype mode
      = NOPROF		(* no profiling *)
      | LATENT		(* compile code for profiling, do call counts *)
      | ACTIVE		(* LATENT + do timings *)

    val mode = ref NOPROF
    val profiling : bool ref = System.Unsafe.profiling

    local
      val pervDone = ref false
    in
    fun doPerv() =
	  if !pervDone then ()
          else (
	    pervDone := true;
	    Control.Print.say "Creating profiled version of standard library\n";
	    ProfEnv.replace Environment.pervasiveEnvRef)
    end

(**
    fun profileOn () =
	  SMLofNJ.IntervalTimer.setProfTimer(SOME(Time.fromMilliseconds msPerSample))
    fun profileOff () =
	  SMLofNJ.IntervalTimer.setProfTimer NONE
**)
    fun profileOn () = ()
    fun profileOff () = ()

    fun setMode m = (
	  case m
	   of NOPROF => (profiling := false; profileOff())
	    | LATENT => (profiling := true; doPerv(); profileOff())
	    | ACTIVE => (profiling := true; doPerv(); profileOn())
	  (* end case *);
	  mode := m)
 
    fun getMode () = !mode

  end;
