(* Copyright 1992 by AT&T Bell Laboratories *)

signature MODULEUTIL =
sig
  exception ErrorStructure
  exception UnboundComponent of SymPath.path
  val appendAccess : Access.access * Access.access -> Access.access
  val bogusCONbind : Modules.binding
  val bogusFCTvar : Modules.functorVar
  val bogusSTRvar : Modules.structureVar
  val mkStructure : Modules.env * InvPath.path -> Modules.Structure
  val eqOrigin : Modules.Structure * Modules.Structure -> bool
  val eqSign : Modules.Signature * Modules.Signature -> bool
  val eqSignature : Modules.Signature * Modules.Signature -> bool
  val eqFsig : Modules.FctSignature * Modules.FctSignature -> bool
  val findPath : InvPath.path * 'a * ('a * 'b -> bool) * 
		 (SymPath.path * ('c -> 'd) -> 'b) -> string
  val getFctStamp : Modules.Functor -> Stamps.stamp
  val getOrigin : Modules.Structure -> Modules.Structure
  val getSigPos : Modules.Signature -> Symbol.symbol -> Modules.strpos
  val getSigPosGen : Modules.Signature -> Symbol.symbol -> Modules.binding
  val getSigTPos : Modules.Signature -> Symbol.symbol -> int
  val getSignStamp : Modules.Signature -> Stamps.stamp
  val getStrPath : Modules.Structure -> InvPath.path
  val getStrPos : Modules.Structure -> Symbol.symbol -> Modules.strpos
  val getStrStamp : Modules.Structure -> Stamps.stamp
  val getStrTPos : Modules.Structure -> Symbol.symbol -> int

  exception Id  (* raised by strId, sigId, fctId, etc. *)
  val strId : Modules.Structure -> ModuleId.modId
  val sigId : Modules.Signature -> ModuleId.modId
  val fctId : Modules.Functor -> ModuleId.modId
  val fsigId : Modules.FctSignature -> ModuleId.modId
  val tycId : Types.tycon -> ModuleId.modId

  val lookArTYC : (Modules.env * Normalize.normMap option) 
		  * SymPath.path * int 
		  * ErrorMsg.complainer -> Types.tycon
  val lookBinding : Modules.Structure * SymPath.path * Access.access
		    -> Modules.binding
  val lookBindingSTR : Modules.Structure * SymPath.path
		       -> Modules.Structure
  val lookBindingTYC : Modules.Structure * SymPath.path -> Types.tycon
  val lookEXN : Modules.env * SymPath.path *
	       ErrorMsg.complainer -> Types.datacon
  val lookFCT : Modules.env * SymPath.path * 
		ErrorMsg.complainer -> Modules.functorVar
  val lookFIX : Modules.env * Symbol.symbol -> Fixity.fixity
  val lookFSIG : Modules.env * Symbol.symbol
		 * ErrorMsg.complainer 
		 -> Modules.FctSignature
  val lookFormalBinding : Modules.env * SymPath.path
			  -> Modules.binding * int list
  val lookGen : (Modules.binding * int list * SymPath.path -> 'a) * 'a 
		-> Modules.env * SymPath.path * ErrorMsg.complainer
		-> 'a
  val lookSIG : Modules.env * Symbol.symbol 
		* ErrorMsg.complainer -> Modules.Signature
  val lookSTR : Modules.env * SymPath.path
		* ErrorMsg.complainer -> Modules.structureVar
  val lookShortVARCON : Modules.env * Symbol.symbol
			* ErrorMsg.complainer
			-> Modules.binding
  val lookTYC : Modules.env * SymPath.path
		* ErrorMsg.complainer -> Types.tycon
  val lookVARCON : Modules.env * SymPath.path
		   * ErrorMsg.complainer -> Modules.binding
  val makeEnv : Modules.Structure * Access.access
		-> Modules.env
  val notInitialLowerCase : string -> bool
  val openSigStructure : 
        Modules.env * SymPath.path * Modules.env * ErrorMsg.complainer
	-> Modules.env
  val openStructureVar : Modules.env * Modules.structureVar
			 -> Modules.env
  val sortEnvBindings : Modules.env
			-> (Symbol.symbol * Modules.binding) list

  val transPosFct : Modules.Structure -> int list -> Modules.Functor
  val transPosStr : Modules.Structure -> int list -> Modules.Structure
  val transPosTycon : Modules.Structure -> int list -> Types.tycon
  val transType : Modules.Structure -> Types.ty -> Types.ty
end
