functor MLLexFun(structure Tokens : ML_TOKENS)=
   struct
    structure UserDeclarations =
      struct
(* Copyright 1989 by AT&T Bell Laboratories *)

open ErrorMsg;

structure TokTable = TokenTable(Tokens);
type svalue = Tokens.svalue
type pos = int
type lexresult = (svalue,pos) Tokens.token
type lexarg = {comLevel : int ref, 
	       lineNum : int ref,
               linePos : int list ref, (* offsets of lines in file *)
	       charlist : string list ref,
	       stringtype : bool ref,
	       stringstart : int ref, (* start of current string or comment*)
               brack_stack : int ref list ref, (* for frags *)
	       err : pos*pos -> ErrorMsg.complainer}
type arg = lexarg
type ('a,'b) token = ('a,'b) Tokens.token
val eof = fn ({comLevel,err,linePos,stringstart,stringtype,
               lineNum,charlist, brack_stack}:lexarg) => 
	   let val pos = Int.max(!stringstart+2, hd(!linePos))
	    in if !comLevel>0 then err (!stringstart,pos) COMPLAIN
					 "unclosed comment" nullErrorBody
		  	      else ();
	       Tokens.EOF(pos,pos)
	   end	
fun addString (charlist,s:string) = charlist := s :: (!charlist)
fun addChar (charlist, c:char) = addString(charlist, String.str c)
fun makeString charlist = (concat(rev(!charlist)) before charlist := nil)
(*
fun makeHexInt sign s = let
      fun digit d = if (d < #"A")
	    then (Char.ord d - Char.ord #"0")
	    else if (d < #"a")
	      then (10 + (Char.ord d - #"A"))
	      else (10 + (Char.ord d - #"a"))
      in
	revfold (fn (c, a) => sign(a*16, digit c)) (explode s) 0
      end
fun makeInt sign s =
    revfold (fn (c,a) => sign(a*10, Char.ord c - Char.ord #"0")) (explode s) 0
*)

fun has_quote s = let
      fun loop i = ((String.sub(s,i) = #"`") orelse loop (i+1))
	    handle _ => false
      in
	loop 0
      end

fun inc (ri as ref i) = (ri := i+1)
fun dec (ri as ref i) = (ri := i-1)
   
end (* end of user routines *)
exception LexError (* raised if illegal leaf action tried *)
structure Internal =
	struct

datatype yyfinstate = N of int
type statedata = {fin : yyfinstate list, trans: string}
(* transition & final state table *)
val tab = let
val s0 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s1 =
"\014\014\014\014\014\014\014\014\014\068\070\014\068\014\014\014\
\\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\014\
\\068\031\067\064\031\031\031\059\057\056\054\031\053\031\050\031\
\\042\040\040\040\040\040\040\040\040\040\031\039\031\031\031\031\
\\031\033\033\033\033\033\033\033\033\033\033\033\033\033\033\033\
\\033\033\033\033\033\033\033\033\033\033\033\038\031\037\031\036\
\\035\033\033\033\033\033\033\033\033\033\033\033\033\033\033\033\
\\033\033\033\033\033\033\033\033\033\033\033\032\031\030\015\014\
\\013"
val s3 =
"\071\071\071\071\071\071\071\071\071\071\076\071\071\071\071\071\
\\071\071\071\071\071\071\071\071\071\071\071\071\071\071\071\071\
\\071\071\071\071\071\071\071\071\074\071\072\071\071\071\071\071\
\\071\071\071\071\071\071\071\071\071\071\071\071\071\071\071\071\
\\071\071\071\071\071\071\071\071\071\071\071\071\071\071\071\071\
\\071\071\071\071\071\071\071\071\071\071\071\071\071\071\071\071\
\\071\071\071\071\071\071\071\071\071\071\071\071\071\071\071\071\
\\071\071\071\071\071\071\071\071\071\071\071\071\071\071\071\071\
\\071"
val s5 =
"\093\093\093\093\093\093\093\093\093\093\094\093\093\093\093\093\
\\093\093\093\093\093\093\093\093\093\093\093\093\093\093\093\093\
\\077\078\092\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\079\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\077\
\\077"
val s7 =
"\095\095\095\095\095\095\095\095\095\097\099\095\097\095\095\095\
\\095\095\095\095\095\095\095\095\095\095\095\095\095\095\095\095\
\\097\095\095\095\095\095\095\095\095\095\095\095\095\095\095\095\
\\095\095\095\095\095\095\095\095\095\095\095\095\095\095\095\095\
\\095\095\095\095\095\095\095\095\095\095\095\095\095\095\095\095\
\\095\095\095\095\095\095\095\095\095\095\095\095\096\095\095\095\
\\095\095\095\095\095\095\095\095\095\095\095\095\095\095\095\095\
\\095\095\095\095\095\095\095\095\095\095\095\095\095\095\095\095\
\\095"
val s9 =
"\100\100\100\100\100\100\100\100\100\100\105\100\100\100\100\100\
\\100\100\100\100\100\100\100\100\100\100\100\100\100\100\100\100\
\\100\100\100\100\100\100\100\100\100\100\100\100\100\100\100\100\
\\100\100\100\100\100\100\100\100\100\100\100\100\100\100\100\100\
\\100\100\100\100\100\100\100\100\100\100\100\100\100\100\100\100\
\\100\100\100\100\100\100\100\100\100\100\100\100\100\100\102\100\
\\101\100\100\100\100\100\100\100\100\100\100\100\100\100\100\100\
\\100\100\100\100\100\100\100\100\100\100\100\100\100\100\100\100\
\\100"
val s11 =
"\106\106\106\106\106\106\106\106\106\112\114\106\112\106\106\106\
\\106\106\106\106\106\106\106\106\106\106\106\106\106\106\106\106\
\\112\107\106\107\107\107\107\106\111\106\107\107\106\107\106\107\
\\106\106\106\106\106\106\106\106\106\106\107\106\107\107\107\107\
\\107\109\109\109\109\109\109\109\109\109\109\109\109\109\109\109\
\\109\109\109\109\109\109\109\109\109\109\109\106\107\106\107\106\
\\106\109\109\109\109\109\109\109\109\109\109\109\109\109\109\109\
\\109\109\109\109\109\109\109\109\109\109\109\106\107\106\107\106\
\\106"
val s15 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\016\000\016\016\016\016\000\000\000\016\016\000\016\000\016\
\\027\018\018\018\018\018\018\018\018\018\016\000\016\016\016\016\
\\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\016\000\016\000\
\\017\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\016\000\016\000\
\\000"
val s16 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\016\000\016\016\016\016\000\000\000\016\016\000\016\000\016\
\\000\000\000\000\000\000\000\000\000\000\016\000\016\016\016\016\
\\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\016\000\016\000\
\\017\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\016\000\016\000\
\\000"
val s17 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\017\000\017\017\017\017\000\000\000\017\017\000\017\000\017\
\\000\000\000\000\000\000\000\000\000\000\017\000\017\017\017\017\
\\017\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\017\000\017\000\
\\017\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\017\000\017\000\
\\000"
val s18 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\022\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\000\000\000\000\019\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s19 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\
\\000"
val s20 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\021\021\021\021\021\021\021\021\021\021\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s22 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\023\023\023\023\023\023\023\023\023\023\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s23 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\023\023\023\023\023\023\023\023\023\023\000\000\000\000\000\000\
\\000\000\000\000\000\024\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s24 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\026\026\026\026\026\026\026\026\026\026\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\025\000\
\\000"
val s25 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\026\026\026\026\026\026\026\026\026\026\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s27 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\022\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\000\000\000\000\019\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\028\000\000\000\000\000\000\000\
\\000"
val s28 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\029\029\029\029\029\029\029\029\029\029\000\000\000\000\000\000\
\\000\029\029\029\029\029\029\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\029\029\029\029\029\029\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s33 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\034\000\000\000\000\000\000\000\000\
\\034\034\034\034\034\034\034\034\034\034\000\000\000\000\000\000\
\\000\034\034\034\034\034\034\034\034\034\034\034\034\034\034\034\
\\034\034\034\034\034\034\034\034\034\034\034\000\000\000\000\034\
\\000\034\034\034\034\034\034\034\034\034\034\034\034\034\034\034\
\\034\034\034\034\034\034\034\034\034\034\034\000\000\000\000\000\
\\000"
val s40 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\022\000\
\\041\041\041\041\041\041\041\041\041\041\000\000\000\000\000\000\
\\000\000\000\000\000\019\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s42 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\022\000\
\\049\049\049\049\049\049\049\049\049\049\000\000\000\000\000\000\
\\000\000\000\000\000\019\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\045\043\000\000\000\000\000\000\000\
\\000"
val s43 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\044\044\044\044\044\044\044\044\044\044\000\000\000\000\000\000\
\\000\044\044\044\044\044\044\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\044\044\044\044\044\044\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s45 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\048\048\048\048\048\048\048\048\048\048\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\046\000\000\000\000\000\000\000\
\\000"
val s46 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\047\047\047\047\047\047\047\047\047\047\000\000\000\000\000\000\
\\000\047\047\047\047\047\047\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\047\047\047\047\047\047\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s48 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\048\048\048\048\048\048\048\048\048\048\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s49 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\022\000\
\\049\049\049\049\049\049\049\049\049\049\000\000\000\000\000\000\
\\000\000\000\000\000\019\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s50 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\051\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s51 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\052\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s54 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\016\000\016\016\016\016\000\000\055\016\016\000\016\000\016\
\\000\000\000\000\000\000\000\000\000\000\016\000\016\016\016\016\
\\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\016\000\016\000\
\\017\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\016\000\016\000\
\\000"
val s57 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\058\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s59 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\063\000\000\000\000\000\000\000\000\
\\062\062\062\062\062\062\062\062\062\062\000\000\000\000\000\000\
\\000\060\060\060\060\060\060\060\060\060\060\060\060\060\060\060\
\\060\060\060\060\060\060\060\060\060\060\060\000\000\000\000\061\
\\000\060\060\060\060\060\060\060\060\060\060\060\060\060\060\060\
\\060\060\060\060\060\060\060\060\060\060\060\000\000\000\000\000\
\\000"
val s60 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\060\000\000\000\000\000\000\000\000\
\\060\060\060\060\060\060\060\060\060\060\000\000\000\000\000\000\
\\000\060\060\060\060\060\060\060\060\060\060\060\060\060\060\060\
\\060\060\060\060\060\060\060\060\060\060\060\000\000\000\000\060\
\\000\060\060\060\060\060\060\060\060\060\060\060\060\060\060\060\
\\060\060\060\060\060\060\060\060\060\060\060\000\000\000\000\000\
\\000"
val s61 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\060\060\060\060\060\060\060\060\060\060\060\060\060\060\060\
\\060\060\060\060\060\060\060\060\060\060\060\000\000\000\000\000\
\\000\060\060\060\060\060\060\060\060\060\060\060\060\060\060\060\
\\060\060\060\060\060\060\060\060\060\060\060\000\000\000\000\000\
\\000"
val s62 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\062\062\062\062\062\062\062\062\062\062\000\000\000\000\000\000\
\\000\060\060\060\060\060\060\060\060\060\060\060\060\060\060\060\
\\060\060\060\060\060\060\060\060\060\060\060\000\000\000\000\000\
\\000\060\060\060\060\060\060\060\060\060\060\060\060\060\060\060\
\\060\060\060\060\060\060\060\060\060\060\060\000\000\000\000\000\
\\000"
val s63 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\062\062\062\062\062\062\062\062\062\062\000\000\000\000\000\000\
\\000\060\060\060\060\060\060\060\060\060\060\060\060\060\060\060\
\\060\060\060\060\060\060\060\060\060\060\060\000\000\000\000\061\
\\000\060\060\060\060\060\060\060\060\060\060\060\060\060\060\060\
\\060\060\060\060\060\060\060\060\060\060\060\000\000\000\000\000\
\\000"
val s64 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\016\066\016\016\016\016\000\000\000\016\016\000\016\000\016\
\\000\000\000\000\000\000\000\000\000\000\016\000\016\016\016\016\
\\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\065\016\000\016\000\
\\017\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\016\000\016\000\
\\000"
val s68 =
"\000\000\000\000\000\000\000\000\000\069\000\000\069\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\069\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s72 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\073\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s74 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\075\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s78 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\078\000\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\000\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\000\
\\000"
val s79 =
"\000\000\000\000\000\000\000\000\000\090\091\000\090\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\090\000\089\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\086\086\086\086\086\086\086\086\086\086\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\085\000\082\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\081\000\
\\000\000\000\000\080\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s82 =
"\083\083\083\083\083\083\083\083\083\083\000\083\083\083\083\083\
\\083\083\083\083\083\083\083\083\083\083\083\083\083\083\083\083\
\\083\083\083\083\083\083\083\083\083\083\083\083\083\083\083\083\
\\083\083\083\083\083\083\083\083\083\083\083\083\083\083\083\083\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\083\083\083\083\083\083\083\083\083\083\083\083\083\083\083\083\
\\083\083\083\083\083\083\083\083\083\083\083\083\083\083\083\083\
\\083"
val s86 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\087\087\087\087\087\087\087\087\087\087\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s87 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\088\088\088\088\088\088\088\088\088\088\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s90 =
"\000\000\000\000\000\000\000\000\000\090\000\000\090\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\090\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s97 =
"\000\000\000\000\000\000\000\000\000\098\000\000\098\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\098\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s102 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\104\000\
\\103\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s107 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\108\000\108\108\108\108\000\000\000\108\108\000\108\000\108\
\\000\000\000\000\000\000\000\000\000\000\108\000\108\108\108\108\
\\108\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\108\000\108\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\108\000\108\000\
\\000"
val s109 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\110\000\000\000\000\000\000\000\000\
\\110\110\110\110\110\110\110\110\110\110\000\000\000\000\000\000\
\\000\110\110\110\110\110\110\110\110\110\110\110\110\110\110\110\
\\110\110\110\110\110\110\110\110\110\110\110\000\000\000\000\110\
\\000\110\110\110\110\110\110\110\110\110\110\110\110\110\110\110\
\\110\110\110\110\110\110\110\110\110\110\110\000\000\000\000\000\
\\000"
val s112 =
"\000\000\000\000\000\000\000\000\000\113\000\000\113\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\113\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
in Vector.fromList
[{fin = [], trans = s0},
{fin = [(N 2)], trans = s1},
{fin = [(N 2)], trans = s1},
{fin = [], trans = s3},
{fin = [], trans = s3},
{fin = [], trans = s5},
{fin = [], trans = s5},
{fin = [(N 208)], trans = s7},
{fin = [(N 208)], trans = s7},
{fin = [], trans = s9},
{fin = [], trans = s9},
{fin = [(N 231)], trans = s11},
{fin = [(N 231)], trans = s11},
{fin = [(N 129),(N 131)], trans = s0},
{fin = [(N 131)], trans = s0},
{fin = [(N 53),(N 62),(N 131)], trans = s15},
{fin = [(N 53),(N 62)], trans = s16},
{fin = [(N 53)], trans = s17},
{fin = [(N 94)], trans = s18},
{fin = [], trans = s19},
{fin = [], trans = s20},
{fin = [(N 84)], trans = s20},
{fin = [], trans = s22},
{fin = [(N 84)], trans = s23},
{fin = [], trans = s24},
{fin = [], trans = s25},
{fin = [(N 84)], trans = s25},
{fin = [(N 94)], trans = s27},
{fin = [], trans = s28},
{fin = [(N 105)], trans = s28},
{fin = [(N 12),(N 131)], trans = s0},
{fin = [(N 53),(N 62),(N 131)], trans = s16},
{fin = [(N 10),(N 131)], trans = s0},
{fin = [(N 42),(N 131)], trans = s33},
{fin = [(N 42)], trans = s33},
{fin = [(N 53),(N 64),(N 131)], trans = s17},
{fin = [(N 6),(N 131)], trans = s0},
{fin = [(N 19),(N 131)], trans = s0},
{fin = [(N 14),(N 131)], trans = s0},
{fin = [(N 21),(N 131)], trans = s0},
{fin = [(N 87),(N 90),(N 131)], trans = s40},
{fin = [(N 87),(N 90)], trans = s40},
{fin = [(N 90),(N 131)], trans = s42},
{fin = [], trans = s43},
{fin = [(N 99)], trans = s43},
{fin = [], trans = s45},
{fin = [], trans = s46},
{fin = [(N 116)], trans = s46},
{fin = [(N 110)], trans = s48},
{fin = [(N 90)], trans = s49},
{fin = [(N 27),(N 131)], trans = s50},
{fin = [], trans = s51},
{fin = [(N 31)], trans = s0},
{fin = [(N 8),(N 131)], trans = s0},
{fin = [(N 53),(N 62),(N 131)], trans = s54},
{fin = [(N 127)], trans = s0},
{fin = [(N 25),(N 131)], trans = s0},
{fin = [(N 23),(N 131)], trans = s57},
{fin = [(N 124)], trans = s0},
{fin = [(N 131)], trans = s59},
{fin = [(N 39)], trans = s60},
{fin = [], trans = s61},
{fin = [], trans = s62},
{fin = [], trans = s63},
{fin = [(N 53),(N 62),(N 131)], trans = s64},
{fin = [(N 17)], trans = s0},
{fin = [(N 121)], trans = s0},
{fin = [(N 118),(N 131)], trans = s0},
{fin = [(N 2),(N 131)], trans = s68},
{fin = [(N 2)], trans = s68},
{fin = [(N 4)], trans = s0},
{fin = [(N 141)], trans = s0},
{fin = [(N 141)], trans = s72},
{fin = [(N 139)], trans = s0},
{fin = [(N 141)], trans = s74},
{fin = [(N 134)], trans = s0},
{fin = [(N 136)], trans = s0},
{fin = [(N 203)], trans = s0},
{fin = [(N 203)], trans = s78},
{fin = [(N 152),(N 179),(N 203)], trans = s79},
{fin = [(N 155)], trans = s0},
{fin = [(N 158)], trans = s0},
{fin = [], trans = s82},
{fin = [(N 172)], trans = s0},
{fin = [(N 168),(N 172)], trans = s0},
{fin = [(N 161)], trans = s0},
{fin = [], trans = s86},
{fin = [], trans = s87},
{fin = [(N 177)], trans = s0},
{fin = [(N 164)], trans = s0},
{fin = [(N 152)], trans = s90},
{fin = [(N 148)], trans = s0},
{fin = [(N 143),(N 203)], trans = s0},
{fin = [(N 181),(N 203)], trans = s0},
{fin = [(N 145),(N 181)], trans = s0},
{fin = [(N 212)], trans = s0},
{fin = [(N 210),(N 212)], trans = s0},
{fin = [(N 208),(N 212)], trans = s97},
{fin = [(N 208)], trans = s97},
{fin = [(N 205)], trans = s0},
{fin = [(N 226)], trans = s0},
{fin = [(N 222),(N 226)], trans = s0},
{fin = [(N 220),(N 226)], trans = s102},
{fin = [(N 215)], trans = s0},
{fin = [(N 218)], trans = s0},
{fin = [(N 224)], trans = s0},
{fin = [(N 247)], trans = s0},
{fin = [(N 243),(N 247)], trans = s107},
{fin = [(N 243)], trans = s107},
{fin = [(N 234),(N 247)], trans = s109},
{fin = [(N 234)], trans = s109},
{fin = [(N 245),(N 247)], trans = s0},
{fin = [(N 231),(N 247)], trans = s112},
{fin = [(N 231)], trans = s112},
{fin = [(N 228)], trans = s0}]
end
structure StartStates =
	struct
	datatype yystartstate = STARTSTATE of int

(* start state definitions *)

val A = STARTSTATE 3;
val AQ = STARTSTATE 11;
val F = STARTSTATE 7;
val INITIAL = STARTSTATE 1;
val Q = STARTSTATE 9;
val S = STARTSTATE 5;

end
type result = UserDeclarations.lexresult
	exception LexerError (* raised if illegal leaf action tried *)
end

fun makeLexer yyinput = 
let 
	val yyb = ref "\n" 		(* buffer *)
	val yybl = ref 1		(*buffer length *)
	val yybufpos = ref 1		(* location of next character to use *)
	val yygone = ref 1		(* position in file of beginning of buffer *)
	val yydone = ref false		(* eof found yet? *)
	val yybegin = ref 1		(*Current 'start state' for lexer *)

	val YYBEGIN = fn (Internal.StartStates.STARTSTATE x) =>
		 yybegin := x

fun lex (yyarg as ({comLevel,lineNum,err,linePos,charlist,stringstart,stringtype,brack_stack})) =
let fun continue() : Internal.result = 
  let fun scan (s,AcceptingLeaves : Internal.yyfinstate list list,l,i0) =
	let fun action (i,nil) = raise LexError
	| action (i,nil::l) = action (i-1,l)
	| action (i,(node::acts)::l) =
		case node of
		    Internal.N yyk => 
			(let val yytext = substring(!yyb,i0,i-i0)
			     val yypos = i0+ !yygone
			fun REJECT() = action(i,acts::l)
			open UserDeclarations Internal.StartStates
 in (yybufpos := i; case yyk of 

			(* Application actions *)

  10 => (Tokens.LBRACE(yypos,yypos+1))
| 105 => (Tokens.INT0(yytext,yypos,yypos+size yytext))
| 110 => (Tokens.WORD(yytext,yypos,yypos+size yytext))
| 116 => (Tokens.WORD(yytext,yypos,yypos+size yytext))
| 118 => (charlist := [""]; stringstart := yypos;
                    stringtype := true; YYBEGIN S; continue())
| 12 => (Tokens.RBRACE(yypos,yypos+1))
| 121 => (charlist := [""]; stringstart := yypos;
                    stringtype := false; YYBEGIN S; continue())
| 124 => (YYBEGIN A; stringstart := yypos; comLevel := 1; continue())
| 127 => (err (yypos,yypos+1) COMPLAIN "unmatched close comment"
		        nullErrorBody;
		    continue())
| 129 => (err (yypos,yypos) COMPLAIN "non-Ascii character"
		        nullErrorBody;
		    continue())
| 131 => (err (yypos,yypos) COMPLAIN "illegal token" nullErrorBody;
		    continue())
| 134 => (inc comLevel; continue())
| 136 => (inc lineNum; linePos := yypos :: !linePos; continue())
| 139 => (dec comLevel; if !comLevel=0 then YYBEGIN INITIAL else (); continue())
| 14 => (Tokens.LBRACKET(yypos,yypos+1))
| 141 => (continue())
| 143 => (let val s = makeString charlist
                        val s = if size s <> 1 andalso not(!stringtype)
                                 then (err(!stringstart,yypos) COMPLAIN
                                      "character constant not length 1"
                                       nullErrorBody;
                                       substring(s^"x",0,1))
                                 else s
                        val t = (s,!stringstart,yypos+1)
                    in YYBEGIN INITIAL;
                       if !stringtype then Tokens.STRING t else Tokens.CHAR t
                    end)
| 145 => (err (!stringstart,yypos) COMPLAIN "unclosed string"
		        nullErrorBody;
		    inc lineNum; linePos := yypos :: !linePos;
		    YYBEGIN INITIAL; Tokens.STRING(makeString charlist,!stringstart,yypos))
| 148 => (inc lineNum; linePos := yypos :: !linePos;
		    YYBEGIN F; continue())
| 152 => (YYBEGIN F; continue())
| 155 => (addString(charlist,"\t"); continue())
| 158 => (addString(charlist,"\n"); continue())
| 161 => (addString(charlist,"\\"); continue())
| 164 => (addChar(charlist, #"\""); continue())
| 168 => (addChar(charlist,
			Char.chr(Char.ord(String.sub(yytext,2))-Char.ord #"@"));
		    continue())
| 17 => (Tokens.VECTORSTART(yypos,yypos+1))
| 172 => (err(yypos,yypos+2) COMPLAIN "illegal control escape; must be one of \
	  \@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_" nullErrorBody;
	 continue())
| 177 => (let val x = Char.ord(String.sub(yytext,1))*100
	     +Char.ord(String.sub(yytext,2))*10
	     +Char.ord(String.sub(yytext,3))
	     -((Char.ord #"0")*111)
  in (if x>255
      then err (yypos,yypos+4) COMPLAIN "illegal ascii escape" nullErrorBody
      else addChar(charlist, Char.chr x);
      continue())
  end)
| 179 => (err (yypos,yypos+1) COMPLAIN "illegal string escape"
		        nullErrorBody; 
		    continue())
| 181 => (err (yypos,yypos+1) COMPLAIN "illegal non-printing character in string" nullErrorBody;
                    continue())
| 19 => (Tokens.RBRACKET(yypos,yypos+1))
| 2 => (continue())
| 203 => (addString(charlist,yytext); continue())
| 205 => (inc lineNum; linePos := yypos :: !linePos; continue())
| 208 => (continue())
| 21 => (Tokens.SEMICOLON(yypos,yypos+1))
| 210 => (YYBEGIN S; stringstart := yypos; continue())
| 212 => (err (!stringstart,yypos) COMPLAIN "unclosed string"
		        nullErrorBody; 
		    YYBEGIN INITIAL; Tokens.STRING(makeString charlist,!stringstart,yypos+1))
| 215 => (addString(charlist, "`"); continue())
| 218 => (addString(charlist, "^"); continue())
| 220 => (YYBEGIN AQ;
                    let val x = makeString charlist
                    in
                    Tokens.OBJL(x,yypos,yypos+(size x))
                    end)
| 222 => ((* a closing quote *)
                    YYBEGIN INITIAL;
                    let val x = makeString charlist
                    in
                    Tokens.ENDQ(x,yypos,yypos+(size x))
                    end)
| 224 => (inc lineNum; addString(charlist,"\n"); continue())
| 226 => (addString(charlist,yytext); continue())
| 228 => (inc lineNum; continue())
| 23 => (if (null(!brack_stack))
                    then ()
                    else inc (hd (!brack_stack));
                    Tokens.LPAREN(yypos,yypos+1))
| 231 => (continue())
| 234 => (YYBEGIN Q; 
                    let val hash = StrgHash.hashString yytext
                    in
                    Tokens.AQID(FastSymbol.rawSymbol(hash,yytext),
				yypos,yypos+(size yytext))
                    end)
| 243 => (YYBEGIN Q; 
                    let val hash = StrgHash.hashString yytext
                    in
                    Tokens.AQID(FastSymbol.rawSymbol(hash,yytext),
				yypos,yypos+(size yytext))
                    end)
| 245 => (YYBEGIN INITIAL;
                    brack_stack := ((ref 1)::(!brack_stack));
                    Tokens.LPAREN(yypos,yypos+1))
| 247 => (err (yypos,yypos+1) COMPLAIN
		       ("ml lexer: bad character after antiquote "^yytext)
		       nullErrorBody;
                    Tokens.AQID(FastSymbol.rawSymbol(0,""),yypos,yypos))
| 25 => (if (null(!brack_stack))
                    then ()
                    else if (!(hd (!brack_stack)) = 1)
                         then ( brack_stack := tl (!brack_stack);
                                charlist := [];
                                YYBEGIN Q)
                         else dec (hd (!brack_stack));
                    Tokens.RPAREN(yypos,yypos+1))
| 27 => (Tokens.DOT(yypos,yypos+1))
| 31 => (Tokens.DOTDOTDOT(yypos,yypos+3))
| 39 => (TokTable.checkTyvar(yytext,yypos))
| 4 => (inc lineNum; linePos := yypos :: !linePos; continue())
| 42 => (TokTable.checkToken(yytext,yypos))
| 53 => (if (!Control.quotation)
                            then if (has_quote yytext)
                                 then REJECT()
                                 else TokTable.checkToken(yytext,yypos)
                            else TokTable.checkToken(yytext,yypos))
| 6 => (Tokens.WILD(yypos,yypos+1))
| 62 => (TokTable.checkToken(yytext,yypos))
| 64 => (if (!Control.quotation)
                            then (YYBEGIN Q;
                                  charlist := [];
                                  Tokens.BEGINQ(yypos,yypos+1))
                            else (err(yypos, yypos+1)
                                     COMPLAIN "quotation implementation error"
				     nullErrorBody;
                                  Tokens.BEGINQ(yypos,yypos+1)))
| 8 => (Tokens.COMMA(yypos,yypos+1))
| 84 => (Tokens.REAL(yytext,yypos,yypos+size yytext))
| 87 => (Tokens.INT(yytext,yypos,yypos+size yytext))
| 90 => (Tokens.INT0(yytext,yypos,yypos+size yytext))
| 94 => (Tokens.INT0(yytext,yypos,yypos+size yytext))
| 99 => (Tokens.INT0(yytext,yypos,yypos+size yytext))
| _ => raise Internal.LexerError

		) end )

	val {fin,trans} = Vector.sub(Internal.tab, s)
	val NewAcceptingLeaves = fin::AcceptingLeaves
	in if l = !yybl then
	     if trans = #trans(Vector.sub(Internal.tab,0))
	       then action(l,NewAcceptingLeaves
) else	    let val newchars= if !yydone then "" else yyinput 1024
	    in if (size newchars)=0
		  then (yydone := true;
		        if (l=i0) then UserDeclarations.eof yyarg
		                  else action(l,NewAcceptingLeaves))
		  else (if i0=l then yyb := newchars
		     else yyb := substring(!yyb,i0,l-i0)^newchars;
		     yygone := !yygone+i0;
		     yybl := size (!yyb);
		     scan (s,AcceptingLeaves,l-i0,0))
	    end
	  else let val NewChar = Char.ord(String.sub(!yyb,l))
		val NewState = if NewChar<128 then Char.ord(String.sub(trans,NewChar)) else Char.ord(String.sub(trans,128))
		in if NewState=0 then action(l,NewAcceptingLeaves)
		else scan(NewState,NewAcceptingLeaves,l+1,i0)
	end
	end
(*
	val start= if substring(!yyb,!yybufpos-1,1)="\n"
then !yybegin+1 else !yybegin
*)
	in scan(!yybegin (* start *),nil,!yybufpos,!yybufpos)
    end
in continue end
  in lex
  end
end
