(* hppaMask.sml
 *
 * COPYRIGHT (c) 1996 Bell Laboratories.
 *)

structure HppaMask : sig
    val regmask : int list -> int 
  end =
struct

  structure C = HppaCells

  fun error msg = ErrorMsg.impossible ("HppaMask." ^ msg)
  val regMap = Array.array(32, Word.fromInt ~1)
  val _ = app (fn (i,j) => Array.update(regMap,i,j))
	       [( 9, 0w0),	(* stdlink *)
		(10, 0w1),	(* stdclos *)
		(11, 0w2),	(* stdarg *)
		(12, 0w3),	(* stdcont *)
		( 1, 0w4),	(* misc0 *)
		(13, 0w5),	(* misc1 *)
		(14, 0w6),	(* ...   *)
		(15, 0w7),
		(16, 0w8),
		(17, 0w9),
		(18, 0w10),
		(19, 0w11),
		(22, 0w12),
		(23, 0w13),
		(24, 0w14),
		(25, 0w15),
		(26, 0w16),
		(28, 0w17),
		(2, 0w18)]
	handle _ => error "setting regMap"

  fun regmask regs = let
    val sentinel = Word.fromInt(~1)
    fun f([],acc) = Word.toInt acc
      | f(r::regs,acc) = let 
	  val bit = Array.sub(regMap, r) 
		       handle _ => error ("regmask: " ^ makestring r)
        in
	  if bit = sentinel then error ("regmask - " ^ makestring r)
	  else f(regs,Word.orb(acc,Word.<<(0w1,bit)))
        end
  in
    f(regs,0w0)
  end

end

