(* hppaInstr.sml
 *
 * COPYRIGHT (c) 1996 Bell Laboratories.
 *)

structure HppaInstruction = struct
  structure C = HppaCells

  datatype store = STW | STH | STB 

  (* All branching is done with nullification *)
  datatype cmp = COMBT | COMBF 

  datatype cmpi = COMIBT | COMIBF

  datatype arith = LDWX | LDHX | LDBX 
    		 | ADD | ADDO | SH1ADD | SH1ADDO 
		 | SUB | SUBO | OR  | XOR | AND 

  datatype arithi = ADDI | ADDIO | SUBI | SUBIO | LDW | LDH | LDB 

  datatype shiftv = VEXTRU | VEXTRS | ZVDEP

  datatype shift = EXTRU | EXTRS | ZDEP

  datatype farith = FADD | FSUB | FMPY | FDIV | XMPYU

  (* FCNVXF --- the source is the LHS single precision floating register *)
  datatype funary = FCPY | FABS | FCNVXF

  datatype fstore = FSTDS | FSTWS

  datatype fstorex = FSTDX | FSTWX

  (* FLDWX and FLDWS -- loads the RHS of the floating register *)
  datatype floadx = FLDDX | FLDWX
 
  datatype fload = FLDDS | FLDWS

  datatype bcond = EQ | LT | LE | LTU | LEU | NE | GE | GT | GTU | GEU

  datatype scond = ALL_ZERO | LEFTMOST_ONE | LEFTMOST_ZERO | RIGHTMOST_ONE
                 | RIGHTMOST_ZERO 

  datatype labexp = POSLAB of Label.label * int
		  | NEGLAB of Label.label * int

  datatype operand =
      HIMaskop of int list
    | LOMaskop of int list
    | HILabExp of labexp
    | LOLabExp of labexp
    | LabExp of labexp
    | IMMED of int

  (* FLDWS, FLDWX = define the R half of the FP register.
   * FSTWS = uses the R half of the FP register.
   *)
  datatype instruction =  
      STORE   of {st:store,   b:int,  d:int,  r:int}
    | ARITH   of {a:arith,    r1:int, r2:int, t:int}
    | ARITHI  of {ai:arithi,  i:int,  r:int,  t:int}
    | COMCLR  of {cc:bcond,   r1:int, r2:int, t:int}
    | SHIFTV  of {sv:shiftv,  r:int,  len:int, t:int}
    | SHIFT   of {s:shift,    r:int,  p:int,  len:int, t:int}
    | BCOND   of {cmp: cmp,   bc:bcond,  r1:int, r2:int, 
		  t:Label.label, f:Label.label}
    | BCONDI  of {cmpi: cmpi, bc:bcond,  i:int,  r2:int, 
		  t:Label.label, f:Label.label}
    | B       of Label.label
    | FBCC    of {t:Label.label, f:Label.label}
    | BV      of {x:int,      b:int,   labs: Label.label list}
    | CALL    of {t:int,      defs: C.cellset, uses: C.cellset}
    | LDIL    of {i:operand,  t:int}
    | LDO     of {i:operand,  b:int,   t:int}
    | LADDR   of {i:operand,  b:int,   t:int}
    | MTCTL   of {r:int, t:int}
    | FSTORE  of {fst:fstore, b:int,   d:int,   r:int}
    | FSTOREX of {fstx:fstorex, b:int, x:int, r:int}
    | FLOAD   of {fl:fload,   b:int,   d:int,   t:int}
    | FLOADX  of {flx:floadx, b:int,   x:int,   t:int}
    | FARITH  of {fa:farith,  r1:int,  r2:int,  t:int}
    | FUNARY  of {fu:funary,  f:int,   t:int}
    | FCMP    of bcond * int * int
    | FTEST
    | BREAK   of int * int
    | NOP

end


