(* hppaCG.sml
 *
 * COPYRIGHT (c) 1996 Bell Laboratories.
 *)

structure HppaFlow = FlowGraph(structure Instr = HppaInstruction)

structure HppaMLTreeGen = MLTREEgen(structure C=HppaCells
				    structure R=HppaSpec)
					   
    		(*-----------------------*)

structure HppaIntRA_Arg = struct
  fun regSet c     = #1 (c:HppaCells.cellset)
  fun cellset((_,f,e),r) = (r,f,e)
  structure Liveness  = 
      Liveness(structure Flowgraph=HppaFlow
	       structure Instruction=HppaInstruction
	       val defUse = HppaProps.defUseR
	       val regSet = regSet
	       val cellset=cellset)
  structure InsnProps = HppaProps

  val defUse       = HppaProps.defUseR
  val getreg       = HppaProps.getreg1
  val spill	   = HppaProps.spill1
  val nFreeRegs    = length HppaCells.availRegs
  val firstPseudoR = 32
  val maxPseudoR   = HppaCells.maxReg
  val regMap	   = hd
end
    		(*-----------------------*)

structure HppaFloatRA_Arg = struct
  fun regSet c     = #2 (c:HppaCells.cellset)
  fun cellset((r,_,e),f) = (r,f,e)
  structure Liveness  = 
      Liveness(structure Flowgraph=HppaFlow
	       structure Instruction=HppaInstruction
	       val defUse=HppaProps.defUseF
	       val regSet=regSet
	       val cellset=cellset)
  structure InsnProps = HppaProps
  val defUse       = HppaProps.defUseF
  val getreg       = HppaProps.getreg2
  val spill	   = HppaProps.spill2
  val nFreeRegs    = length HppaCells.availFRegs
  val firstPseudoR = 32
  val maxPseudoR   = HppaCells.maxFreg
  val regMap	   = hd o tl
end

    		(*-----------------------*)

functor HppaCG(structure Emitter : EMITTER_NEW
		sharing Emitter.I = HppaInstruction) = 
struct
  structure I = HppaInstruction
  structure C = HppaCells

  fun icount n = ErrorMsg.impossible "HppaCG.icount"


  structure BBsched =
     BBSched2(structure Flowgraph = HppaFlow
	      structure InsnProps = HppaProps
	      structure Emitter = Emitter
	      val icount = icount)

  structure FloatRAlloc = 
     RegAllocator(structure Ra= HppaFloatRA_Arg
		  structure Emitter=HppaAsmEmitter
		  val codegen = fn blks => (BBsched.bbsched blks))
  structure IntRAlloc = 
     RegAllocator(structure Ra = HppaIntRA_Arg
		  structure Emitter=HppaAsmEmitter
		  val codegen = fn blks => (HppaProps.FR.reset();
					    FloatRAlloc.ra blks))
  structure Gsched = 
     GlobalSched(structure Flowgraph = HppaFlow
		 val codegen = fn blks => (HppaProps.spillInit();
					   HppaProps.GR.reset();
					   IntRAlloc.ra blks))
  structure FlowGen = 
     FlowGraphGen(structure Flowgraph = HppaFlow
		  structure InsnProps = HppaProps
		  val codegen = Gsched.gsched)

  structure MLTreeComp  = Hppa(structure Flowgen=FlowGen)

  fun cleanUp () = (FlowGen.cleanUp(); BBsched.cleanUp())

  val finish = fn x => (BBsched.finish x)
end

