(* scstatenv.sig
 *
 * COPYRIGHT (c) 1996 Bell Laboratories.
 *)

signature SCSTATICENV =
sig
  type staticEnv
  val unSC : staticEnv -> StaticEnv.staticEnv
  val atop : staticEnv * staticEnv -> staticEnv
  val SC : StaticEnv.staticEnv -> staticEnv
  
  val lookSTR: staticEnv -> ModuleId.modId -> Modules.Structure option
  val lookSIG: staticEnv -> ModuleId.modId -> Modules.Signature option
  val lookFSIG: staticEnv -> ModuleId.modId -> Modules.FctSignature option
  val lookFCT: staticEnv -> ModuleId.modId -> Modules.Functor option
  val lookTYC: staticEnv -> ModuleId.modId -> Types.tycon option

  val debugging : bool ref
end
