(* recorder.sml
 *
 * COPYRIGHT (c) 1996 Bell Laboratories.
 *)

(* recorder.sml *)

signature RECORDER =
sig
  type symbol
  type modId
  type table
  val makeRecorder: unit -> 
               ({path: symbol list, id: modId} -> unit) * table ref
end

structure Recorder : RECORDER =
struct

  type modId = ModuleId.modId
  type symbol = Symbol.symbol
  type table = symbol list ModuleTable.table

  fun makeRecorder () =
      let val tableRef = ref(ModuleTable.empty: table)
          fun record {path,id} =
	      tableRef := ModuleTable.bind(id,path,!tableRef)
       in (record, tableRef)
      end

(*
  (* printing, for debugging *)
  (* printSequence, printSym, and prSymPath copied from PrintUtil *)
Q  val say = Control.Print.say

  fun printSequence (separator: string) pr elems =
      let fun prElems [el] = pr el
	    | prElems (el::rest) = (pr el; say separator; prElems rest)
	    | prElems [] = ()
       in prElems elems
      end

  fun printSym(s: symbol) = say(Symbol.name s)

  val prSymPath = printSequence "." printSym

  fun prTable (table : table) =
      ModuleTable.app (fn (_,p) => (prSymPath p; say "\n")) table 
*)
end (* structure Recorder *)
