(* Copyright 1992 by AT&T Bell Laboratories *)

signature ELABSIG =
sig
  type context
  val elabEMBEDsig : 
      (Ast.region -> ErrorMsg.complainer) *
      Ast.region -> context * Symbol.symbol -> Ast.sigexp
      -> Modules.Signature
  val elabFSIGB : 
      (Ast.region -> ErrorMsg.complainer) * 
      Ast.region -> Modules.env * Stamps.scope ->
      Symbol.symbol * Ast.fsigexp 
       -> Modules.funsigVar list * Modules.env
  val elabPARTIALsig :
      (Ast.region -> ErrorMsg.complainer) *
      Ast.region ->
      Symbol.symbol * Modules.Signature * Modules.env * Normalize.normMap ref *
      (unit -> Stamps.stamp) ->
      Ast.sigexp 
      -> Modules.Signature
  val elabTOPsig : 
      (Ast.region -> ErrorMsg.complainer) * 
      Ast.region -> 
      Modules.binding Env.env * (unit->Stamps.stamp) * Symbol.symbol option ->
      Ast.sigexp
      -> Modules.Signature
  val make_fsigexp : 
      (Ast.region -> ErrorMsg.complainer) *
      Ast.region -> Symbol.symbol option ->
      context -> Ast.fsigexp
       -> Modules.FctSignature
  val debugging : bool ref
end
