(* hstore.sml
 *
 * COPYRIGHT (c) 1996 Bell Laboratories.
 *)

(* hstore.sml *)

structure HistoricalArray (* : ARRAY *) =
struct
  local
    val cast = System.Unsafe.cast
    open System.Weak Debugger
  in
    open Array
    fun array(cnt:int,obj:'1a) : '1a array = cast (hcreatea(cnt,cast obj)) 
	(* will raise Subscript if cnt < 0 *)

    fun fromList (nil:'1a list) : '1a array = 
	  cast(hcreatea(0,cast 0 (* ?? *)))
      | fromList (l as (e::r)) =
	    let val a = array(List.length l, e)
	        fun init ((e::r),n) = (update(a,n,e); init(r,n+1))
  	          | init (nil,_) = ()
  	    in  init(r,1); a
            end

(* We handle update in the instrumenter for efficiency; it could be 
   handled here thus: 
    fun update (arr, offset, value) =
	  (Array.update(arr,offset,value);
	   updatedAList := PCONS(weak(cast arr),offset,!updatedAList))
*)

    fun tabulate (i:int,f:int -> '1a) : '1a array =
      let fun tab j = 
	  if j < i then f j::tab(j+1) else nil
      in if i < 0 then raise Size else fromList (tab 0)
      end
  end (*local*)
end (*struct*)

(*
structure HistoricalRef =
struct
  local
    val cast = System.Unsafe.cast
    open System.Weak Debugger

  in
    open Ref
    (* We handle op := directly in the instrumenter for efficiency;
	  it could be handled here as follows:
      val op := = fn (r,value) => 
		  (Ref.:= (r,value);
		   updatedRList := weak (cast r) :: (!updatedRList)) *)
  
  end (*local*)
end (*struct*)

*)
