(* mltree.sig
 *
 * COPYRIGHT (c) 1994 AT&T Bell Laboratories.
 *)

(** The signature should also contain a structure that matches CELLS
 ** and provides functions to perform newReg, newFreg, and resetRegs
 **)
signature MLTREE = sig
  datatype bcond = LT | LTU | LE | LEU | EQ | NEQ | GEU

  datatype order = LR | RL

  datatype ovflType = Overflow | DivByZero | Ovfl_DivByZero

  datatype mlrisc = 
      REG    of int
    | FREG   of int

    | LI     of int
    | LI32   of Word32.word
    | MV     of mlrisc * mlrisc				(* dest, src *)
    | FMV    of mlrisc * mlrisc

    | ADD    of mlrisc * mlrisc
    | SUB    of mlrisc * mlrisc * order
    | MULU   of mlrisc * mlrisc
    | DIVU   of mlrisc * mlrisc * order

    | ADDT   of mlrisc * mlrisc 
    | MULT   of mlrisc * mlrisc
    | SUBT   of mlrisc * mlrisc * order
    | DIVT   of mlrisc * mlrisc * order

    | FADDD  of mlrisc * mlrisc
    | FMULD  of mlrisc * mlrisc
    | FSUBD  of mlrisc * mlrisc * order
    | FDIVD  of mlrisc * mlrisc * order
    | FABSD  of mlrisc 
    | FNEGD  of mlrisc

    | LADDR  of Label.label * int
    | LBASE  of mlrisc * Label.label

    | BR     of Label.label
    | JMP    of mlrisc
    | GOTO   of mlrisc * Label.label list
    | CALL   of mlrisc * mlrisc list * mlrisc list
    | RET

    | LOAD8  of mlrisc
    | LOAD32 of mlrisc
    | LOADD  of mlrisc
    | STORE8  of mlrisc * mlrisc			    (* address, data *)
    | STORE32 of mlrisc * mlrisc			    (* address, data *)
    | STORED  of mlrisc * mlrisc			    (* address, data *)

    | ANDB   of mlrisc * mlrisc
    | ORB    of mlrisc * mlrisc
    | XORB   of mlrisc * mlrisc

    | SRA   of mlrisc * mlrisc * order			     (* value, shift *)
    | SRL   of mlrisc * mlrisc * order
    | SLL   of mlrisc * mlrisc * order

    | CVTI2D of mlrisc

    | TESTLIMIT  of mlrisc * mlrisc
    | CHECKLIMIT of Label.label
    | LDREGMASK  of mlrisc list

    | BCC       of bcond * mlrisc * mlrisc * Label.label * order
    | FBCC      of bcond * mlrisc * mlrisc * Label.label * order

    | SEQ of mlrisc * mlrisc
    | BARRIER of ovflType 

  datatype mltree = 
      MARK
    | LABEL of Label.label
    | JMPTABLE of {base:Label.label,targets:Label.label list}
    | REALCONST of Label.label * string
    | STRINGCONST of Label.label * string
    | CODE of mlrisc
    | BEGINCLUSTER
    | ENDCLUSTER
    | ESCAPEBLOCK of mlrisc list
 
  val prTree : mltree -> unit

end (* MLTREE *)

