(* mltBurmIn.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

signature MLTBurmOps = sig
  datatype ops = REG    | FREG
	       | LI     | LI32
	       | MV     | FMV
	       | LADDR  | LBASE   | LOAD8 | LOAD32 | LOADD
	       | STORE8 | STORE32 | STORED
	       | ADD    | SUB     | MULU  | DIVU    
	       | ADDT   | SUBT    | MULT  | DIVT
	       | ANDB   | ORB     | XORB
	       | SRA    | SRL     | SLL
	       | FADDD  | FSUBD   | FMULD | FDIVD  | FABSD | FNEGD  | CVTI2D
	       | BR     | JMP     | GOTO  | BCC    | FBCC  | CALL   | RET
	       | SEQ    | BARRIER
	       | TESTLIMIT  | CHECKLIMIT  | LDREGMASK
end

functor MLTBurmIn(Ops : MLTBurmOps) = struct
  structure T  = MLTree
  type tree = T.mlrisc

  fun opchildren(T.REG _)          = (Ops.REG,     [])
    | opchildren(T.FREG _)         = (Ops.FREG,    [])
    | opchildren(T.LI _)           = (Ops.LI,      [])
    | opchildren(T.LI32 _)         = (Ops.LI32,    [])
    | opchildren(T.MV(t1,t2))      = (Ops.MV,      [t1,t2])
    | opchildren(T.FMV(t1,t2))	   = (Ops.FMV,     [t1,t2])
    | opchildren(T.LADDR _)        = (Ops.LADDR,   [])
    | opchildren(T.LBASE(t,_))     = (Ops.LBASE,   [t])
    | opchildren(T.LOAD8(t))       = (Ops.LOAD8,   [t])
    | opchildren(T.LOAD32(t))      = (Ops.LOAD32,  [t])
    | opchildren(T.LOADD(t))       = (Ops.LOADD,   [t])
    | opchildren(T.STORE8(t1,t2))  = (Ops.STORE8,  [t1,t2])
    | opchildren(T.STORE32(t1,t2)) = (Ops.STORE32, [t1,t2])
    | opchildren(T.STORED(t1,t2))  = (Ops.STORED,  [t1,t2])
    | opchildren(T.ADD(t1,t2))     = (Ops.ADD,     [t1,t2])
    | opchildren(T.SUB(t1,t2,_))   = (Ops.SUB,     [t1,t2])
    | opchildren(T.MULU(t1,t2))    = (Ops.MULU,    [t1,t2])
    | opchildren(T.DIVU(t1,t2,_))  = (Ops.DIVU,    [t1,t2])
    | opchildren(T.ADDT(t1,t2))    = (Ops.ADDT,    [t1,t2])
    | opchildren(T.SUBT(t1,t2,_))  = (Ops.SUBT,    [t1,t2])
    | opchildren(T.MULT(t1,t2))    = (Ops.MULT,    [t1,t2])
    | opchildren(T.DIVT(t1,t2,_))  = (Ops.DIVT,    [t1,t2])
    | opchildren(T.ANDB(t1,t2))    = (Ops.ANDB,    [t1,t2])
    | opchildren(T.ORB(t1,t2))     = (Ops.ORB,     [t1,t2])
    | opchildren(T.XORB(t1,t2))    = (Ops.XORB,    [t1,t2])
    | opchildren(T.SRA(t1,t2,_))   = (Ops.SRA,     [t1,t2])
    | opchildren(T.SRL(t1,t2,_))   = (Ops.SRL,     [t1,t2])
    | opchildren(T.SLL(t1,t2,_))   = (Ops.SLL,     [t1,t2])
    | opchildren(T.CVTI2D t)	   = (Ops.CVTI2D,  [t])
    | opchildren(T.TESTLIMIT(t1,t2))=(Ops.TESTLIMIT, [t1,t2])
    | opchildren(T.CHECKLIMIT _)   = (Ops.CHECKLIMIT,[])
    | opchildren(T.LDREGMASK _)    = (Ops.LDREGMASK, [])
    | opchildren(T.FADDD(t1,t2))   = (Ops.FADDD,   [t1,t2])
    | opchildren(T.FSUBD(t1,t2,_)) = (Ops.FSUBD,   [t1,t2])
    | opchildren(T.FMULD(t1,t2))   = (Ops.FMULD,   [t1,t2])
    | opchildren(T.FDIVD(t1,t2,_)) = (Ops.FDIVD,   [t1,t2])
    | opchildren(T.FABSD(t1))      = (Ops.FABSD,   [t1])
    | opchildren(T.FNEGD(t1))      = (Ops.FNEGD,   [t1])
    | opchildren(T.BCC(_,t1,t2,_,_)) = (Ops.BCC,   [t1,t2])
    | opchildren(T.FBCC(_,t1,t2,_,_))= (Ops.FBCC,  [t1,t2])
    | opchildren(T.BR _)           = (Ops.BR,      [])
    | opchildren(T.JMP t)          = (Ops.JMP,     [t])
    | opchildren(T.GOTO(t,_))      = (Ops.GOTO,    [t])
    | opchildren(T.CALL(t,_,_)) = (Ops.CALL,	   [t])
    | opchildren(T.SEQ(t1,t2))	   = (Ops.SEQ,     [t1,t2])
    | opchildren(T.BARRIER _)	   = (Ops.BARRIER, [])
end (* MLTBurmIn *)


