(* labels.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

signature LABEL =
  sig
    datatype label = Label of {id : int, addr : int ref, comment:string}

    val newLabel : string -> label
    val nameOf   : label -> string
    val id       : label -> int
    val addrOf   : label -> int
    val reset	 : unit -> unit
    val setAddr  : label * int -> unit
  end


structure Label : LABEL =
  struct
    datatype label = Label of {id:int, addr:int ref, comment:string}

    val cnt 		           = ref 0
    fun newLabel msg 	           = Label{id= !cnt,addr=ref 0,comment=msg} 
      					before (cnt := !cnt+1)
    fun nameOf(Label{id,...})      = "L" ^ Int.toString id
    fun id(Label{id,...})          = id
    fun addrOf(Label{addr,...})    = !addr
    fun setAddr(Label{addr,...},n) = addr := n
    fun reset() 		   = cnt := 0
  end

