(* frag.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

signature FRAG = sig
  datatype generated 
    = UNGEN of CTree.var list * CPS.cty list * CTree.funCtree
    | GEN of MLTree.mlrisc list

  datatype frag
    = STANDARD of 
         (CPS.lvar * CTree.var list * CPS.cty list * CTree.funCtree) option ref * int 
    | KNOWNFUN of generated ref
    | KNOWNCHK of generated ref * int
    | STRINGfrag of string
    | REALfrag of string
end (* FRAG *)




structure Frag : FRAG = struct
  datatype generated 
    = UNGEN of CTree.var list * CPS.cty list * CTree.funCtree
    | GEN of MLTree.mlrisc list

  datatype frag
    = STANDARD of 
       (CPS.lvar * CTree.var list * CPS.cty list * CTree.funCtree) option ref * int
    | KNOWNFUN of generated ref
    | KNOWNCHK of generated ref * int
    | STRINGfrag of string
    | REALfrag of string

end (* Frag *)



