(* cpsRegs.sig
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *
 * The registers used for CPS compilation.
 *)

signature CPSREGS = sig
  val allocptr 	: MLTree.mlrisc
  val limitptr 	: MLTree.mlrisc
  val stdlink	: MLTree.mlrisc
  val stdclos	: MLTree.mlrisc
  val stdarg 	: MLTree.mlrisc 
  val stdcont 	: MLTree.mlrisc 
  val exnptr 	: MLTree.mlrisc 
  val varptr  	: MLTree.mlrisc 
  val baseptr	: MLTree.mlrisc 
  val storeptr 	: MLTree.mlrisc 
  val stackptr 	: MLTree.mlrisc 
  val maskreg 	: MLTree.mlrisc 
  val gclinkreg	: MLTree.mlrisc 
  (* calleesave: may no longer be required --- check *)
  val calleesave: MLTree.mlrisc Array.array
  val exhausted : MLTree.mlrisc

  val miscregs  : MLTree.mlrisc list
  val floatregs : MLTree.mlrisc list
  val savedfpregs : MLTree.mlrisc list

  val newReg    : unit -> int
  val newFreg   : unit -> int
  val resetRegs : unit -> unit
end
