(* cells.sig
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *
 * CELLS - describes storage units on the machine, such as
 *         dedicated and general registers, memory ...
 *
 *	 This file acts as a bridge between MLRISC and the machine 
 *	 code.
 *)

signature CELLS = sig
  structure T : MLTREE

  val allocptr 	: T.mlrisc
  val limitptr 	: T.mlrisc
  val stdlink	: T.mlrisc
  val stdclos	: T.mlrisc
  val stdarg 	: T.mlrisc 
  val stdcont 	: T.mlrisc 
  val exnptr 	: T.mlrisc 
  val varptr  	: T.mlrisc 
  val baseptr	: T.mlrisc 
  val storeptr 	: T.mlrisc 
  val stackptr 	: T.mlrisc 
  val maskreg 	: T.mlrisc 
  val gclinkreg	: T.mlrisc 
  val exhausted : T.mlrisc 
  val miscregs  : T.mlrisc list
  val calleesave: T.mlrisc Array.array
  val floatregs : T.mlrisc list
  val savedfpregs: T.mlrisc list
   
  val newReg    : unit -> int
  val newFreg   : unit -> int
  val resetRegs : unit -> unit

  (* get rid of type cell *)
  type cell
  val regMap 		: MLTree.mlrisc -> cell
  val fregMap		: MLTree.mlrisc -> cell

  type cellset		
  val cellset2string    : cellset -> string
  val addReg		: int * cellset -> cellset
  val addFreg		: int * cellset -> cellset
  val empty		: cellset

  val dedicated         : cellset
end

