(* shareglue.sml
 *
 * Copyright 1989 by AT&T Bell Laboratories
 *
 * shareglue: a functor application common to all architectures.
 *)

functor IntShare (structure VC : VISCOMP) : sig end = 
  struct
    structure BootEnv = BootEnvF(VC)

  (* environment initializations *)
    val _ = (
	#set Environment.pervasiveEnvRef (BootEnv.makePervEnv());
	#set Environment.topLevelEnvRef Environment.emptyEnv)

  (* establish default signal handlers *)
    local
      fun handleINT _ = !System.Unsafe.topLevelCont
      fun handleTERM _ = OS.Process.exit OS.Process.failure
      fun ifSignal (sigName, handler) = (case (Signals.fromString sigName)
	     of (SOME s) => (
		  Signals.setHandler (s, Signals.HANDLER handler); ())
	      | _ => ()
	    (* end case *))
    in
    val _ = (
	Signals.setHandler (Signals.sigINT, Signals.HANDLER handleINT);
	Signals.setHandler (Signals.sigTERM, Signals.HANDLER handleTERM);
	ifSignal ("QUIT", handleTERM))
    end

  (* launch interactive loop *)
    val _ = (
	Control.Print.say "Go for it\n";
	VC.Interact.interact())

  end



