(* interact.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

signature INTERACT =
sig
  exception Interrupt

  val interact : unit -> unit
  val use_file : string -> unit
  val use_stream : instream -> unit
  val eval_stream : instream * Environment.environment -> 
                       Environment.environment

  val installCompManager:
      (Ast.dec *
       { get: unit -> Environment.environment,
	 set: Environment.environment -> unit } *
       { get: unit -> Environment.environment,
	 set: Environment.environment -> unit }
       -> unit) option
      -> unit
end

functor Interact(EvalLoop : EVALLOOP) : INTERACT =
struct

  exception Interrupt = EvalLoop.Interrupt

 (*
  * This is where CM can install itelf into.  Added for the purpose of
  * autoloading. (blume)
  *)
  type envRef = EvalLoop.envRef
  val compManagerHook: (Ast.dec * envRef * envRef -> unit) option ref
      = ref NONE
  fun installCompManager m = compManagerHook := m

  fun stdParams () =
      {compManagerHook = compManagerHook,
       baseEnvRef= Environment.pervasiveEnvRef,
       localEnvRef=Environment.topLevelEnvRef,
       transform=(fn x => x),
       instrument=(fn _ => fn x => x),
       perform=(fn x => x),
       isolate=CompUtil.isolate,
       printer=PPDec.ppDec}

  fun interact() =  EvalLoop.interact (stdParams())

  fun use_file (fname: string) =
      (app Control.Print.say ["[opening ",fname,"]\n"];
       EvalLoop.eval_stream (stdParams())
		  (fname,(open_in fname
			  handle e as Io _ =>
			      (app Control.Print.say["[use failed: ",
						     General.exnMessage e,
						     "]\n"];
			       raise ErrorMsg.Error))))

  fun use_stream (stream: instream) =
      EvalLoop.eval_stream (stdParams()) ("<instream>", stream)

  fun eval_stream (stream: instream, baseEnv: Environment.environment) : 
      Environment.environment =
      let val r = ref Environment.emptyEnv
	  val localEnvRef = {get=(fn()=> !r),set=(fn x=>r:=x)}
	  val b = ref baseEnv
       in EvalLoop.eval_stream
	          {compManagerHook = ref NONE,
		   (* ????  should CM get its hands into that? *)
		   baseEnvRef = {get=(fn()=> !b),set=(fn x=>b:=x)},
		   localEnvRef=localEnvRef,
		   transform=(fn x => x), instrument=(fn _ => fn x => x),
		   perform=(fn x => x),
		   isolate=CompUtil.isolate,
		   printer=PPDec.ppDec}
		  ("<instream>", stream);
	  #get localEnvRef ()
      end

end (* functor Interact *)




