(* weak.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

abstraction Weak : WEAK =
  struct
    type 'a weak = 'a
    fun weak (x : 'a) : 'a weak = InlineT.mkspecial(Tags.special_weak, x)
    fun strong (x : 'a weak) : 'a option =
	  if InlineT.getspecial x = Tags.special_weak
	    then SOME(InlineT.PolyArray.sub(InlineT.cast x, 0))
	    else NONE
    type weak' = Assembly.object
    fun weak' x = InlineT.mkspecial(Tags.special_weak, x)
    fun strong' x = InlineT.getspecial x = Tags.special_weak
  end

abstraction Susp : SUSP =
  struct
  open Overloads
    type 'a susp = 'a
    fun delay (f : unit -> 'a) = InlineT.mkspecial(Tags.special_unevaled_susp, f)
    fun force (x : 'a susp) =
	  if InlineT.getspecial x = Tags.special_unevaled_susp
	    then let
	      val y : 'a = InlineT.PolyArray.sub (InlineT.cast x, 0) ()
	      in
		InlineT.PolyArray.update (InlineT.cast x, 0, y);
		InlineT.setspecial(InlineT.cast x, Tags.special_evaled_susp);
		y
	      end
	    else InlineT.PolyArray.sub (InlineT.cast x, 0)
  end 

