(* realarray.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

(* NO SIGNATURE, to allow inlining to work correctly *)
structure RealArray =
struct
  open Overloads
  exception RealSubscript = General.Subscript
  exception Size = General.Size
  type realarray = Assembly.A.realarray
  val length : realarray -> int = InlineT.Float64Array.length
  fun array (n : int, v : real) =
      if InlineT.DfltInt.ltu(Core.max_length, n) 
	  (* catch negative-length arrays, and 
	    arrays with a size too big to fit in the descriptor *)
      then (if n<0 then raise Size else Assembly.realarray0)
      else let val a = Assembly.A.create_r n
	       fun init i = if i=n then ()
			    else (InlineT.Float64Array.update(a,i,v); init (i+1))
	    in init 0; a
	   end
  val op sub : realarray * int -> real = InlineT.Float64Array.chkSub
  val op update : realarray * int * real -> unit = InlineT.Float64Array.chkUpdate
end  (* RealArray *)
