(* real-sig.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

signature REAL =
  sig
    type real

(***
    structure ToLarge : CVT_REAL_INT
      sharing type ToLarge.real = real
	  and type ToLarge.int = LargestInt.int

    structure ToInt : CVT_REAL_INT
      sharing type ToInt.real = real
	  and type ToInt.int = Int.int
***)

    val floor : real -> Int.int
    val ceil  : real -> Int.int
    val trunc : real -> Int.int
    val round : real -> Int.int
    val real  : Int.int -> real

    val + : real * real -> real
    val - : real * real -> real
    val * : real * real -> real
    val / : real * real -> real
    val ~ : real -> real

    val abs      : real -> real
    val sign     : real -> int
    val sameSign : (real * real) -> bool

    val toDefault   : real -> Real.real
    val fromDefault : Real.real -> real

    val < : real * real -> bool
    val <= : real * real -> bool
    val > : real * real -> bool
    val >= : real * real -> bool

    val toString   : real -> string
    val fromString : string -> real option
    val scan : (char, 'a) StringCvt.reader -> (real, 'a) StringCvt.reader
    val fmt  : StringCvt.realfmt -> real -> string

  end;
