(* perv.sig
 *
 * COPYRIGHT (c) 1994 AT&T Bell Laboratories.
 *
 * Most of these signatures will be relocated in order to conform with the
 * new basis.
 *)

signature REAL_ARRAY = 
  sig
      eqtype realarray
      exception RealSubscript
      exception Size
      val length: realarray -> int
      val array: int * real -> realarray
      val sub: realarray * int -> real
      val update: realarray * int * real -> unit
  end

signature IO =
  sig
    type instream 
    type outstream
    exception Io of  {name: string, function: string, cause: exn}
    val std_in : instream
    val std_out : outstream
    val std_err : outstream
    val open_in : string -> instream
    val open_out : string -> outstream
    val open_append : string -> outstream
    val open_string : string -> instream
    val close_in : instream -> unit
    val close_out : outstream -> unit
    val output : outstream * string -> unit
    val outputc : outstream -> string -> unit
    val input : instream * int -> string
    val inputc : instream -> int -> string
    val input_line : instream -> string
    val lookahead : instream -> string
    val end_of_stream : instream -> bool
    val can_input : instream -> int
    val flush_out : outstream -> unit
    val is_term_in : instream -> bool
    val is_term_out : outstream -> bool
    val set_term_in : instream * bool -> unit
    val set_term_out : outstream * bool -> unit
    val execute : (string * string list) -> instream * outstream
    val execute_in_env : string * string list * string list
	                 -> instream * outstream
  end

signature PRINT = 
  sig
     val int : int -> unit
     val real : real -> unit
     val bool : bool -> unit
     val string : string -> unit
  end

