(* general.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

structure General : PRE_GENERAL =
  struct

    type unit = PrimTypes1.unit
    type exn = PrimTypes1.exn

    open Assembly (* for type 'a option *)

    exception Bind = Core.Bind
    exception Match = Core.Match
    exception Subscript = Core.Subscript
    exception Size = Core.Size
    exception Overflow = Assembly.Overflow
    exception Div = Assembly.Div
    exception Domain

    exception Fail of string

    exception Option
    fun getOpt (SOME x, y) = x
      | getOpt (NONE, y) = y
    fun isSome (SOME _) = true
      | isSome NONE = false
    fun valOf (SOME x) = x
      | valOf _ = raise Option

    datatype order = LESS | EQUAL | GREATER

    val op = : ''a * ''a -> bool  = InlineT.=
    val op <> : ''a * ''a -> bool = InlineT.<>

    val ! = InlineT.!
    val op := = InlineT.:=

(*
    fun f o g = fn x => f(g x)
    fun a before b = a
*)
    val op o : ('b -> 'c) * ('a -> 'b) -> ('a -> 'c) = InlineT.compose
    val op before : ('a * 'b) -> 'a = InlineT.before
    fun ignore _ = ()

  (** the IO exceptions should get moved to the IO structure **)
    exception Io of {name: string,
                 function: string,
                 cause: exn}
    exception BlockingNotSupported
    exception NonBlockingNotSupported
    exception TerminatedStream
    exception ClosedStream


  end (* structure General *)

(* rebind the structure to preserve inlining *)
structure General =
  struct
    open General
    val op = : ''a * ''a -> bool  = InlineT.=
    val op <> : ''a * ''a -> bool = InlineT.<>
    val ! = InlineT.!
    val op := = InlineT.:=
    val op o : ('b -> 'c) * ('a -> 'b) -> ('a -> 'c) = InlineT.compose
    val op before : ('a * 'b) -> 'a = InlineT.before
  end

