(* general-sig.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

signature PRE_GENERAL =
  sig

    type unit
    type exn

    exception Bind
    exception Match
    exception Subscript
    exception Size
    exception Overflow
    exception Div
    exception Domain

    exception Fail of string

  (** the IO exceptions should get moved to the IO structure **)
    exception Io of {
	name     : string,
	function : string,
	cause    : exn
      }
    exception BlockingNotSupported
    exception NonBlockingNotSupported
    exception TerminatedStream
    exception ClosedStream

    datatype 'a option = NONE | SOME of 'a

    exception Option
    val getOpt : ('a option * 'a) -> 'a
    val isSome : 'a option -> bool
    val valOf : 'a option -> 'a

    datatype order = LESS | EQUAL | GREATER

    val = : ''a * ''a -> bool
    val <> : ''a * ''a -> bool

    val !  : 'a ref -> 'a
    val := : ('a ref * 'a) -> unit

    val o      : ('b -> 'c) * ('a -> 'b) -> ('a -> 'c)
    val before : ('a * 'b) -> 'a
    val ignore : 'a -> unit

  end

signature GENERAL = 
  sig
    include PRE_GENERAL

    val exnName : exn -> string
    val exnMessage: exn -> string

  end

