(* exn-name.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *
 * Eventually, this should move to PreBasis so that we don't need the PreGeneral
 * structure anymore.
 *)

structure ExnName : sig

    val exnName : exn -> string
    val exnMessage : exn -> string

  end = struct

    val string_tag = Tags.make_desc(0, Tags.tag_string)

  (* Normal exception names are strings; debugger exception names
   * are pairs of the form string * int.
   *)
    fun normalExnName (x : Assembly.object) = (InlineT.gettag x = string_tag)

    val exnName : exn -> string = InlineT.cast(
	  fn (ref s, _,_) => if normalExnName (InlineT.cast s)
		then s 
		else let val (s,_) = InlineT.cast s in s end)

    fun exnMessage (OS.SysErr(s, NONE)) =
	  "SysErr: " ^ s
      | exnMessage (OS.SysErr(s, SOME e)) =
	  concat["SysErr: ", s, " [", OS.errorName e, "]"]
      | exnMessage (Fail s) =
	  "Fail: " ^ s
      | exnMessage (Io{cause, function, name}) = 
	  concat [
	      "Io: ", function, " failed on file ", name, " with ", exnMessage cause
	    ]
      | exnMessage e =
	  exnName e

  end
