(* Copyright 1989 by AT&T Bell Laboratories *)
(*
The following are already in the symbol table:
     1) Magical words that can be free in signatures (from PrimTypes):
		int string bool unit real list array ref exn
     2) Built-in constructors (from PrimTypes):
		:: nil ref true false
     3) Built-in structures:
		PrimTypes InLine
	The InLine structure is not typed (all values have type alpha).
All matches in this file should be exhaustive; the match and bind exceptions
 are not defined at this stage of bootup, so any uncaught match will cause
 an unpredictable error.
*)


structure Core = 
  struct
    structure Assembly : ASSEMBLY = Assembly

    infix 7  * / quot mod rem div
    infix 6 ^ + -
    infix 3 := o
    infix 4 > < >= <=
    infixr 5 :: @
    infix 0 before

    exception Bind
    exception Match

    exception Ord        	(* OBSOLETE *)
    exception Range      	(* for bytearray update *)
    exception Subscript  	(* for all bounds checking *)
    exception RealSubscript	(* OBSOLETE *)
    exception Size 

    local exception NoProfiler
    in val profile_register =
      ref(fn s:string => (raise NoProfiler):int*int array*int ref)
    end

    val vector0 = Assembly.vector0  (* needed to compile ``#[]'' *)

    local val ieql : int * int -> bool = InLine.i31eq
          val peql : 'a * 'a -> bool = InLine.ptreql
          val ineq : int * int -> bool = InLine.i31ne
          val feql : real * real -> bool = InLine.f64eq
          val boxed : 'a -> bool = InLine.boxed
          val length : 'a -> int = InLine.length
          val op + : int * int -> int = InLine.i31add
          val op - : int * int -> int = InLine.i31sub
          val op * : int * int -> int = InLine.i31mul
          val ordof : string * int -> int = InLine.ordof
          val cast : 'a -> 'b = InLine.cast
          val getObjTag : 'a -> int = InLine.gettag
          val sub : 'a * int -> 'a = InLine.arrSub
          val andb : int * int -> int = InLine.i31andb
	  val width_tags = 6  (* 4 tag bits plus "10" *)
	  val lshift : int * int -> int = InLine.i31lshift
          val stringCreate : int -> string = Assembly.A.create_s
          val stringUpdate : string * int * char -> unit = InLine.store
          val stringSub : string * int -> char = InLine.ordof
          fun dupstring (a : string) = let val len = length a
              (* unsafe string create, no size check !!! but this is only
	       * used for copying string literals.
	       *)
                val ss = stringCreate (len)
                fun copy n = if ieql(n,len)
		      then ()
                      else (stringUpdate(ss, n, stringSub(a,n)); copy(n+1))
		in
		  copy 0; ss
		end

    in 

       (* limit of array, string, etc. element count is one greater than 
          the maximum length field value (sign should be 0) *)
       val max_length = lshift(1, 31 - width_tags) - 1
       val dupstring = dupstring

     (* all the string literals appeared in this file should be 
      * called by the "dupstring" function first.
      *)
       val errorMatch = ref (dupstring("_"))

       fun stringequal(a : string,b : string) =
	  if peql(a,b) then true
          else let
	    val len = length a
            in
	      if ieql(len, length b)
                 then let fun f 0 = true
                            | f i = let val j = (op -)(i,1)
                	             in if ieql(ordof(a,j),ordof(b,j))
              	                        then f j else false
              	                    end
	               in f len
                      end
	         else false
	    end

       fun polyequal (a : 'a, b : 'a) = peql(a,b)
	    orelse (boxed a andalso boxed b
	    andalso let val aTag = getObjTag a
		        fun pairEq () = 
                          let val bTag = getObjTag b
		           in (ieql(bTag,0x02) orelse ineq(andb(bTag,0x3),0x2))
			      andalso polyequal(sub(a,0), sub(b,0))
			      andalso polyequal(sub(a,1), sub(b,1))
		          end
		     in case aTag
		         of 0x02 (* tag_pair *) => pairEq()
		          | 0x06 (* tag_reald *) => feql(cast a,cast b)
		          | 0x12 (* tag_special *) => false
		          | 0x22 (* tag_record *) => 
                             if ieql(getObjTag b,aTag)
			     then let val lenm1 = (length a)-1
			              fun m (j : int) = if ieql(j,lenm1)
				        then polyequal(sub(a,j),sub(b,j))
				        else polyequal(sub(a,j),sub(b,j)) 
                                             andalso m(j+1)
			           in m 0
			          end
			     else false
		          | 0x26 (* tag_array *) => false
		          | 0x2a (* tag_string *) => 
                             stringequal(cast a,cast b)
		          | 0x32 (* tag_bytearray *) => false
		          | 0x36 (* tag_realdarray *) => false
		          | _ (* tagless pair *) => pairEq()
		        (* end case *)
		    end)
    end (* local *)
       val profile_sregister = ref(fn (x:Assembly.object,s:string)=>x)

end
