(* cinterface-sig.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

signature CINTERFACE =
  sig

    exception CFunNotFound of string
    val c_function : string -> string -> ('a -> 'b)
	(* the operation for binding ML callable C functions; raises
	 * the exception CFunNotFound if the function is unknown.
	 *)

  (* utilities for working with system constants *)
    type system_const = (int * string)

    exception SysConstNotFound of string

    val findSysConst : (string * system_const list) -> system_const option
    val bindSysConst : (string * system_const list) -> system_const

  end

