(* blast.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

structure Blast : sig

    val blastWrite : 'a -> Word8Vector.vector
    val blastRead  :  Word8Vector.vector -> 'a

  end = struct 

    structure W8V = Word8Vector

    val blastWrite : 'a -> W8V.vector = CInterface.c_function "SMLNJ-RunT" "blastOut"
    val blastRead  : W8V.vector -> 'a = CInterface.c_function "SMLNJ-RunT" "blastIn"

  end
