(* bind-toplevel.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *
 * This file binds the top-level identifiers from SML Standard Library in
 * the pervasive top-level environment.
 *)

open PrimTypes1 IO Int Real General

(* top-level identifiers *)

(* Misc *)
val vector = Vector.fromList

(* Bool *)
val not = Bool.not

(* List *)
val null   = List.null
val hd     = List.hd
val tl     = List.tl
val length = List.length
val rev    = List.rev
val (op @) = List.@
val app    = List.app
val map    = List.map
val foldr  = List.foldr
val foldl  = List.foldl

(* Char *)
val ord = Char.ord
val chr = Char.chr

(* String *)
val size	= String.size
val str		= String.str
val concat	= String.concat
val implode	= String.implode
val explode	= String.explode
val substring	= String.substring
val (op ^)	= String.^

(* Substring *)
type substring = Substring.substring

