(* rpc-db.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

structure NetRPCDB : NET_RPC_DB =
  struct

    val netdbFun = CInterface.c_function "SMLNJ-Sockets"

    datatype entry = RPCENT of {
	  name : string,
	  aliases : string list,
	  number : int
	}

    local
      fun conc field (RPCENT a) = field a
    in
    val name = conc #name
    val aliases = conc #aliases
    val number = conc #number
    end (* local *)

  (* RPC DB query functions *)
    local
      type rpcent = (string * string list * int)
      fun getRPCEnt NONE = NONE
	| getRPCEnt (SOME(name, aliases, number)) = SOME(RPCENT{
	      name = name, aliases = aliases, number = number
	    })
      val getRPCByName' : string -> rpcent option = netdbFun "getRPCByName"
      val getRPCByNumber' : int -> rpcent option = netdbFun "getRPCByNum"
    in
    val getByName = getRPCEnt o getRPCByName'
    val getByNumber = getRPCEnt o getRPCByNumber'
    end (* local *)

  end
