(* wrap-export.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *
 * This is the wrapper for standalone programs.
 *)

structure WrapExport : sig

    val wrap : ((string * string list) -> OS.Process.status)
	  -> (string * string list) -> 'a

  end = struct

    structure Process = OS_Process

    fun wrap f args = (
	  CleanUp.clean CleanUp.AtInitFn;
	  Process.exit((f args) handle exn => Process.failure))

  end (* WrapExport *)

