(* export.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

structure Export : EXPORT =
  struct

    structure Process = OS_Process

    val runtimeFn = CInterface.c_function "SMLNJ-RunT"

    val exportHeap : string -> bool
	  = runtimeFn "exportHeap"

  (* We need the cast to make sure that the second argument will be fully
   * wrapped when it is passed to the run-time system.
   *)
    val exportFun  : (string * ((string * string list) -> int)) -> 'b =
	  InlineT.cast(runtimeFn "exportFn")

  (* export the current world to the given file *)
    fun exportML fileName = (
	  CleanUp.clean CleanUp.AtExportML;
	  if (exportHeap fileName)
	    then (
	      CleanUp.clean CleanUp.AtInit;
	      true)
	  else false)

(** NOTE: we probably should install a signal handler for SIGINT **)
    fun exportFn (fileName, f) = (
	  Signals.maskSignals Signals.MASKALL;
	  CleanUp.clean CleanUp.AtExportFn;
	  Assembly.pstruct := InlineT.cast ();
	  Core.errorMatch := "_";
	  exportFun (fileName, WrapExport.wrap f)
	  (* this never returns here *))

  end (* Export *)

