(* textio-sig.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

signature TEXT_IO =
  sig
    include IMPERATIVE_IO
      sharing type pos=Position.int

    val openIn : string -> instream
    val openOut: string -> outstream
    val openAppend: string -> outstream

    structure StreamIO : sig
	include STREAM_IO
	val inputLine: instream -> string
      end
	sharing type StreamIO.elem = char
	sharing type StreamIO.vector = string

    val stdIn : instream
    val stdOut: outstream
    val stdErr: outstream

    val inputLine : instream -> string
  end
