(* streamio-sig.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

signature STREAM_IO =
  sig
    structure PrimIO : PRIM_IO

    type elem
      sharing type elem = PrimIO.elem
    type vector
      sharing type vector = PrimIO.vector
    type subvector
    type pos
      sharing type pos = PrimIO.pos

    type instream
    type outstream

    val mkInstream   : PrimIO.reader -> instream
    val closeIn      : instream -> unit
    val setPosIn     : instream * pos -> instream
    val getPosIn     : instream -> pos
    val endPosIn     : instream -> pos
    val input        : instream -> vector * instream
    val inputAll     : instream -> vector
    val inputNoBlock : instream -> (vector * instream) option
    val input1       : instream -> elem option * instream
    val inputN       : instream * int -> vector * instream
    val endOfStream  : instream -> bool
    val getReader    : instream -> PrimIO.reader

    val mkOutstream : PrimIO.writer -> outstream
    val closeOut : outstream -> unit
    val output    : (outstream * vector) -> unit
    val outputS   : (outstream * subvector) -> unit
    val output1   : (outstream * elem) -> unit
    val flushOut : outstream -> unit
    val getPosOut  : outstream -> pos
    val setPosOut  : outstream * pos -> unit
    val endPosOut  : outstream -> pos
    val getWriter: outstream -> PrimIO.writer

  end
