(* prim-io-sig.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

signature PRIM_IO =
  sig
    type elem
    type vector
    type array
    type pos
    val posLess : pos * pos -> bool

    datatype reader = Rd of {
	readBlock    : (int -> vector) option,
	readaBlock   : ({data: array, first: int, nelems: int} -> int) option,
	readNoBlock  : (int -> vector option) option,
	readaNoBlock : ({data: array, first: int, nelems: int} -> int option) option,
	block        : (unit -> unit) option,
	canInput     : (unit -> bool) option,
	name         : string,
	chunkSize    : int,
	close        : unit -> unit,
	getPos       : unit -> pos,
	findPos      : {data: vector, first: int, nelems: int}*pos -> pos,
	setPos       : (pos -> unit),
	endPos       : (unit -> pos),
	desc         : OS.IO.io_desc option
      }

    datatype writer = Wr of {
	writeNoBlock  : ({data: vector, first: int, nelems: int} -> int option) option,
	writeaNoBlock : ({data: array, first: int, nelems: int} -> int option) option,
	writeBlock    : ({data: vector, first: int, nelems: int} -> int) option,
	writeaBlock   : ({data: array, first: int, nelems: int} -> int) option,
	block         : (unit->unit) option,
	canOutput     : (unit->bool) option,
	name          : string,
	chunkSize     : int,
	lineBuf       : (elem -> bool) option,
	close         : unit -> unit,
	getPos        : (unit->pos),
	setPos        : (pos->unit),
	endPos        : (unit->pos),
	desc          : OS.IO.io_desc option
      }

    val augmentIn : reader -> reader
    val augmentOut: writer -> writer

  end
