(* ioclean.sml
 *
 * COPYRIGHT (c) 1995 AT&T Bell Laboratories.
 *)

structure IOClean : sig

    val addclean: {flush: (unit -> unit), close: (unit -> unit) option} -> unit

  end = struct

    val cleaners : {flush: (unit -> unit), close: (unit -> unit) option} list ref
	  = ref nil

    fun addclean f = cleaners := f :: !cleaners

    fun cleanIO (CleanUp.AtExit | CleanUp.AtInit | CleanUp.AtExportFn) = let
	(* close and flush all streams *)
	  fun g ((s as {close=NONE, flush})::rest) = (flush(); s :: g rest)
            | g ({close=SOME f, flush}::rest) = (f() handle _ => (); g rest)
	    | g [] = []
          in
	    cleaners := g(!cleaners)
	  end
      | cleanIO CleanUp.AtExportML =  
	(* flush all streams *)
         List.app (fn{close, flush} => flush()) (!cleaners)
      | cleanIO CleanUp.AtInitFn = ()
        
    val _ = (CleanUp.addCleaner("IOclean", CleanUp.atAll, cleanIO))

  end

