(* Copyright 1989 by AT&T Bell Laboratories *)
(* types.sig *)

signature TYPES =
sig

    type tycpos
    type polysign      (* = {weakness: int, eq: bool} list *)
    type label         (* = symbol *)

    (* absfbpos (abstracted functor body position): where to find
       a type constructor or structure when instantiating a functor body.
       It's either in the parameter or in a sequence of types defined
       or generated by the functor body.

       The list for the PARAM variant is the path through the structure
       instantiation arrays.  For type constructors, the final element is
       the position in a type instantiation array.   A nil list for the PARAM
        variant is used to return the entire parameter structure; it is not
        a valid path for a type constructor. *)
        
    datatype absfbpos = PARAM of int list
                      | SEQind of int * int list
	              | SEQ of int

    datatype eqprop = YES | NO | IND | OBJ | DATA | UNDEF

    val infinity : int

    type tyvar  (* = tvinfo ref *)

    datatype tvinfo		(* type variable info *)
      = INSTANTIATED of ty
      | OPEN of
	  {depth: int,
	   weakness: int,
	   eq: bool,
	   kind: tvkind}

    and tvkind 	
      = META                        (* metavariables: 
                                       depth = infinity for metaargs
		                       depth < infinity for lambda bound *)
      | UBOUND of Symbol.symbol	    (* user bound type variables --- 
                                       symbol is the user name of variable *)
      | FLEX of (label * ty) list   (* flex record variables ---
                                       field name, field type pairs *)

    and datacon  (* exceptions are a special case with rep=VARIABLE() *)
      = DATACON of
	  {name  : Symbol.symbol,
	   const : bool,
	   typ   : ty,
           orig  : ty option,
	   rep   : Access.conrep,
	   sign  : Access.conrep list}

    and tyckind
      = PRIMtyc  		     (* primitive type constructors like int *)
      | ABStyc of tycon	     (* abstract type constructors formed by abstype *)
      | DATAtyc of datacon list      (* datatype constructors *)
      | FORMtyck
      | FORMDEFtyc of tycon  (* type def spec in signature *)

    and tycon
      = GENtyc of
          {stamp : Stamps.stamp, 
	   arity : int, 
	   eq    : eqprop ref,
	   kind	 : tyckind ref,
	   path  : InvPath.path}
      | DEFtyc of
	  {tyfun : tyfun,
	   strict: bool list,
	   path  : InvPath.path}
      | RECORDtyc of label list
      | FORMtyc of
	  {pos : int,
	   spec : tycon,
	   name : Symbol.symbol}
      | OPENFORMtyc of
	  {pos: tycpos,
	   spec : tycon,
	   path : SymPath.path}
      | RELtyc of
	  {pos : tycpos,
	   spec: tycon,
	   path : InvPath.path}
      | ABSFBtyc of absfbpos * tycon
      | ERRORtyc
      | FULLtyc (* added to reserve ERRORtyc for true errors *)
      | EXTERNtyc of ModuleId.modId

    and ty 
      = VARty of tyvar
      | CONty of tycon * ty list
	(* inferred bound type variables -- indexed *)
      | IBOUND of int
      | WILDCARDty
      | POLYty of {sign: {weakness:int, eq:bool} list, tyfun: tyfun, abs: int}
      | UNDEFty

    and tyfun
      = TYFUN of
          {arity : int,
	   body : ty}

    val mkTyvar   : tvinfo -> tyvar
    val bogusCON : datacon
    val bogusEXN : datacon

end (* signature TYPES *)
