(* alpha32Mask.sml
 *
 * COPYRIGHT (c) 1996 Bell Laboratories.
 *)

(** This is temporary until we modify the runtime system with the new mask **)

structure Alpha32Mask : sig val regmask : int list -> int end =
struct

  structure C = Alpha32Cells
    
  fun error msg = ErrorMsg.impossible ("Alpha32Mask." ^ msg)

  val regMap = Array.array(C.nrRegs, Word.fromInt C.nrRegs)
  fun mapR(i,j) = Array.update(regMap,i,j)
                  handle zap => (print "alpha32Mask.mapR exception \n"; raise zap)

  val _ = app (fn (i,j) => Array.update(regMap,i,j))
	       [( 3, 0w0),	(* stdlink *)
		( 2, 0w1),	(* stdclos *)
		( 0, 0w2),	(* stdarg *)
		( 1, 0w3),	(* stdcont *)
		( 6, 0w4),	(* misc0 *)
		( 7, 0w5),	(* misc1 *)
		( 8, 0w6),	(* ...   *)
		(16, 0w7),
		(17, 0w8),
		(18, 0w9),
		(19, 0w10),
		(20, 0w11),
		(21, 0w12),
		(22, 0w13),
		(23, 0w14),
		(24, 0w15),
		(25, 0w16),
		(26, 0w17)]
	handle _ => error "setting regMap"

  fun regmask regs = let
      val sentinel = Word.fromInt C.nrRegs
      fun f([],acc) = Word.toInt acc
	| f(r::regs,acc) = let 
          val bit = Array.sub(regMap,r) 
	      	       handle _ => error ("regmask: " ^ makestring r)
        in
	    if bit = sentinel then error ("regmask - " ^ makestring r)
	    else f(regs, Word.orb(acc, Word.<<(0w1,bit)))
        end
    in
	f(regs,0w0)
    end

end

