(* alpha32CG.sml
 *
 * COPYRIGHT (c) 1996 Bell Laboratories.
 *)

structure Alpha32Flow = FlowGraph(structure Instr = Alpha32Instr)

structure Alpha32MLTreeGen = MLTREEgen(structure C=Alpha32Cells
				       structure R=Alpha32Spec)
					   
    		(*-----------------------*)

structure Alpha32IntRA_Arg = struct
  fun regSet c     = #1 (c:Alpha32Cells.cellset)
  fun cellset((_,f,e),r) = (r,f,e)
  structure Liveness  = 
      Liveness(structure Flowgraph=Alpha32Flow
	       structure Instruction=Alpha32Instr
	       val defUse=Alpha32Props.defUseR
	       val regSet=regSet
	       val cellset=cellset)
  structure InsnProps = Alpha32Props

  val defUse       = Alpha32Props.defUseR
  val getreg       = Alpha32Props.getreg1
  val spill	   = Alpha32Props.spill1
  val nFreeRegs    = length Alpha32Cells.availRegs
  val firstPseudoR = Alpha32Cells.nrRegs
  val maxPseudoR   = Alpha32Cells.maxReg
  val regMap	   = hd
end
    		(*-----------------------*)

structure Alpha32FloatRA_Arg = struct
  fun regSet c     = #2 (c:Alpha32Cells.cellset)
  fun cellset((r,_,e),f) = (r,f,e)
  structure Liveness  = 
      Liveness(structure Flowgraph=Alpha32Flow
	       structure Instruction=Alpha32Instr
	       val defUse=Alpha32Props.defUseF
	       val regSet=regSet
	       val cellset=cellset)
  structure InsnProps = Alpha32Props

  val defUse       = Alpha32Props.defUseF
  val getreg       = Alpha32Props.getreg2
  val spill	   = Alpha32Props.spill2
  val nFreeRegs    = length Alpha32Cells.availFregs
  val firstPseudoR = Alpha32Cells.nrFregs
  val maxPseudoR   = Alpha32Cells.maxFreg
  val regMap	   = hd o tl
end

    		(*-----------------------*)

functor Alpha32CG(structure Emitter : EMITTER_NEW
		sharing Emitter.I = Alpha32Instr) = 
struct
  structure I = Alpha32Instr
  structure C = Alpha32Cells

 
   fun icount n = if n <= 32767 then	
                      I.LDA(C.icountR, C.icountR, I.IMMop n)
    		 else
   		   (print "Alpha32.icount : block to big!\n";
   		    I.LDA(C.icountR, C.icountR, I.IMMop 32767))

  structure BBsched =
      		BBSched2(structure Flowgraph = Alpha32Flow
			structure InsnProps = Alpha32Props
			structure Emitter = Emitter
			val icount = icount)

  structure FloatRAlloc = 
              RegAllocator(structure Ra= Alpha32FloatRA_Arg
			   structure Emitter=Alpha32AsmEmitter
			   val codegen = BBsched.bbsched)

  structure IntRAlloc = 
              RegAllocator(structure Ra = Alpha32IntRA_Arg
			   structure Emitter=Alpha32AsmEmitter
			   val codegen = fn blks => (Alpha32Props.FR.reset();
						     FloatRAlloc.ra blks))

  structure FlowGen = 
        	FlowGraphGen(structure Flowgraph = Alpha32Flow
			     structure InsnProps = Alpha32Props
			     val codegen = fn blks => (Alpha32Props.spillInit();
						       Alpha32Props.GR.reset();
						       IntRAlloc.ra blks))

  structure MLTreeComp  = Alpha32(structure Flowgen=FlowGen)

  fun cleanUp () = (FlowGen.cleanUp(); BBsched.cleanUp())

  val finish = BBsched.finish
end

