/* mkcode.c
 *
 * COPYRIGHT (c) 1994 by AT&T Bell Laboratories.
 */

#include "cache-flush.h"
#include "ml-base.h"
#include "ml-values.h"
#include "ml-state.h"
#include "ml-objects.h"
#include "cfun-proto-list.h"


/* _ml_RunT_mkcode : string -> (code_string * (unit -> unit))
 *
 * Turn a string into a code-string, and a bootable closure.  This means
 * copying it to code space and flushing the I-cache.
 */
ml_val_t _ml_RunT_mkcode (ml_state_t *msp, ml_val_t arg)
{
    Word_t	nbytes = OBJ_LEN(arg);
    ml_val_t	code, closure, res;

    code = ML_AllocCode (msp, nbytes);
    arg = REC_SEL(msp->ml_arg, 1); /* in case ML_AllocCode caused GC */

  /* copy the string into the code object */
    memcpy (PTR_MLtoC(char, code), PTR_MLtoC(char, arg), nbytes);

    FlushICache (PTR_MLtoC(char, code), nbytes);

    REC_ALLOC1(msp, closure, PTR_CtoML(PTR_MLtoC(ml_val_t, code) + 1));
    REC_ALLOC2(msp, res, arg, closure);

    return res;

} /* end of _ml_RunT_mkcode */

