/* system.c
 *
 * COPYRIGHT (c) 1992 by AT&T Bell Laboratories.
 */

#include "ml-base.h"
#include "ml-values.h"
#include "ml-c.h"
#include "cfun-proto-list.h"

/* _ml_OS_system : string -> int
 *
 * Issue the given shell command and return the exit status.
 */
ml_val_t _ml_OS_system (ml_state_t *msp, ml_val_t arg)
{
    int		sts;

    sts = system (PTR_MLtoC(char, arg));

    CHK_RETURN_VAL(msp, sts, INT_CtoML (sts));

} /* end of _ml_OS_system */

