/* settime.c
 *
 * COPYRIGHT (c) 1995 by AT&T Bell Laboratories.
 */

#include "ml-unixdep.h"
#include <sys/types.h>
#include <utime.h>
#include "ml-base.h"
#include "ml-values.h"
#include "tags.h"
#include "ml-objects.h"
#include "ml-c.h"
#include "cfun-proto-list.h"


/* _ml_OS_settime : (string * int option) -> unit
 *
 * Set the modification and access time of the specified file.
 */
ml_val_t _ml_OS_settime (ml_state_t *msp, ml_val_t arg)
{
    ml_val_t		timeOpt = REC_SEL(arg, 1);
    struct utimbuf	utbuf, *utp;
    int			sts;

    if (isBOXED(timeOpt)) {
	time_t	time = (time_t)REC_SELINT(timeOpt, 0);
	utbuf.actime = time;
	utbuf.modtime = time;
	utp = &utbuf;
    }
    else
	utp = NIL(struct utimbuf *);

    sts = utime(PTR_MLtoC(char, arg), utp);

    CHK_RETURN_UNIT(msp, sts);

} /* end of _ml_OS_modtime */

