/* readdir.c
 *
 * COPYRIGHT (c) 1994 AT&T Bell Laboratories.
 */

#include "ml-unixdep.h"
#include <sys/types.h>
#include <dirent.h>
#include "ml-base.h"
#include "ml-objects.h"
#include "ml-c.h"
#include "cfun-proto-list.h"

/* _ml_OS_readdir:
 */
ml_val_t _ml_OS_readdir (ml_state_t *msp, ml_val_t arg)
{
    struct dirent	*dp;

    dp = readdir (PTR_MLtoC(DIR, arg));

    if (dp == NIL(struct dirent *))
      /* end of directory; return "" */
	return ML_string0;
    else
	return ML_CString(msp, dp->d_name);

} /* end of _ml_OS_readdir */
