/* opendir.c
 *
 * COPYRIGHT (c) 1994 AT&T Bell Laboratories.
 */

#include "ml-unixdep.h"
#include <sys/types.h>
#include <dirent.h>
#include "ml-base.h"
#include "ml-values.h"
#include "ml-c.h"
#include "cfun-proto-list.h"

/* _ml_OS_opendir:
 */
ml_val_t _ml_OS_opendir (ml_state_t *msp, ml_val_t arg)
{
    DIR		*dir;

    if ((dir = opendir(PTR_MLtoC(char, arg))) == NIL(DIR *))
	return RAISE_ERROR(msp, "unable to open directory");
    else
	return PTR_CtoML(dir);

} /* end of _ml_OS_opendir */
