/* modtime.c
 *
 * COPYRIGHT (c) 1994 by AT&T Bell Laboratories.
 */

#include "ml-unixdep.h"
#include <sys/stat.h>
#include "ml-base.h"
#include "ml-values.h"
#include "tags.h"
#include "ml-objects.h"
#include "ml-c.h"
#include "cfun-proto-list.h"


/* _ml_OS_modtime : string -> int
 *
 * Get the most recent modification time of the specified file.
 */
ml_val_t _ml_OS_modtime (ml_state_t *msp, ml_val_t arg)
{
    struct stat	    buf;
    int		    sts;

    sts = stat(PTR_MLtoC(char, arg), &buf);
    
    CHK_RETURN_VAL(msp, sts, INT_CtoML(buf.st_mtime));

} /* end of _ml_OS_modtime */

