/* isdir.c
 *
 * COPYRIGHT (c) 1994 AT&T Bell Laboratories.
 */

#include "ml-unixdep.h"
#include <sys/types.h>
#include <sys/stat.h>
#include "ml-base.h"
#include "ml-values.h"
#include "ml-c.h"
#include "cfun-proto-list.h"

/* _ml_OS_isdir:
 *
 * Is the named file a directory?
 */
ml_val_t _ml_OS_isdir (ml_state_t *msp, ml_val_t arg)
{
    struct stat	    buf;
    int		    sts;

    sts = stat(PTR_MLtoC(char, arg), &buf);

    CHK_RETURN_VAL(msp, sts, (S_ISDIR(buf.st_mode) ? ML_true : ML_false));

} /* end of _ml_OS_isdir */
