/* osval.c
 *
 * COPYRIGHT (c) 1995 by AT&T Bell Laboratories.
 */

#include "ml-unixdep.h"
#include "ml-base.h"
#include "ml-values.h"
#include "tags.h"
#include "ml-objects.h"
#include "ml-c.h"
#include "cfun-proto-list.h"
#include <errno.h>
#include "posix-name-val.h"

static name_val_t values [] = {
  {"acces", EACCES},
  {"again", EAGAIN},
  {"badf", EBADF},
#ifdef EBADMSG
  {"badmsg", EBADMSG},
#else
  {"badmsg", 0},
#endif
  {"busy", EBUSY},
#ifdef ECANCELED
  {"canceled", ECANCELED},
#else
  {"canceled", 0},
#endif
  {"child", ECHILD},
  {"deadlk", EDEADLK},
  {"dom", EDOM},
  {"exist", EEXIST},
  {"fault", EFAULT},
  {"fbig", EFBIG},
  {"inprogress", EINPROGRESS},
  {"intr", EINTR},
  {"inval", EINVAL},
  {"io", EIO},
  {"isdir", EISDIR},
  {"loop", ELOOP},
  {"mfile", EMFILE},
  {"mlink", EMLINK},
  {"msgsize", EMSGSIZE},
  {"nametoolong", ENAMETOOLONG},
  {"nfile", ENFILE},
  {"nodev", ENODEV},
  {"noent", ENOENT},
  {"noexec", ENOEXEC},
  {"nolck", ENOLCK},
  {"nomem", ENOMEM},
  {"nospc", ENOSPC},
  {"nosys", ENOSYS},
  {"notdir", ENOTDIR},
  {"notempty", ENOTEMPTY},
#ifdef ENOTSUP
  {"notsup", ENOTSUP},
#else
  {"notsup", 0},
#endif
  {"notty", ENOTTY},
  {"nxio", ENXIO},
  {"perm", EPERM},
  {"pipe", EPIPE},
  {"range", ERANGE},
  {"rofs", EROFS},
  {"spipe", ESPIPE},
  {"srch", ESRCH},
  {"toobig", E2BIG},
  {"xdev", EXDEV},
};

#define NUMELMS ((sizeof values)/(sizeof (name_val_t)))

/* _ml_P_Error_osval : string -> int
 *
 * Return the OS-dependent, compile-time constant specified by the string.
 */
ml_val_t _ml_P_Error_osval (ml_state_t *msp, ml_val_t arg)
{
    name_val_t      *res;
    
    res = _ml_posix_nv_lookup (PTR_MLtoC(char, arg), values, NUMELMS);
    if (res)
        return INT_CtoML(res->val);
    else {
        errno = EINVAL;
	return RaiseSysError(msp, NIL(char *));
    }

} /* end of _ml_P_Error_osval */
