#include "queue.h"
#include <stdio.h>

#define TRUE 1
#define FALSE 0
#define INITIAL_QUEUE_POWER 6
#define SIZE(x) (1 << x)
#define MASK(x) (SIZE(x) - 1)

/* Invariants: 
 *
 * (q->rear = q->front) implies empty queue
 *
 * Otherwise,
 *
 * q->rear points to the position of the next element to be inserted.
 * q->front points to the position of the first element in the queue.
 */

queue_t queue_alloc()
{
  queue_t q;
  q = (queue_t)malloc(sizeof(queue));
  if (q==NULL)
    Die("queue_alloc: out of memory\n");
  q->size = SIZE(INITIAL_QUEUE_POWER);
  q->power = INITIAL_QUEUE_POWER;
  q->mask = MASK(INITIAL_QUEUE_POWER);
  q->front = 0;
  q->rear = 0;
  q->elts = (ml_any_t *)malloc((q->size)*sizeof(ml_any_t));
/*  q->num_elts = 0; */
  if (q->elts == NULL)
    Die("queue_alloc elts: out of memory\n");
  return q;
}

void queue_enqueue (q,d)
     queue_t q;
     ml_any_t d;
{
  int r,m,f,s2;
  ml_any_t *temp;

  q->elts[q->rear] = d;
  m = q->mask;
  r = (q->rear + 1) & m;
  if (r == q->front) {
    s2 = q->size * 2;
    temp = (ml_any_t *)malloc(s2*sizeof(ml_any_t));
    if (temp == NULL)
      Die("queue_enqueue: out of memory\n");
    for (f=q->front, r=0; f != q->rear; f =(f+1)&m, r++) {
      temp[r] = (q->elts)[f];
    }
    temp[r] = (q->elts)[f];
    r++;
    free(q->elts);
    q->elts = temp;
    q->front = 0;
    q->size = s2;
    q->power = (q->power)+1;
    q->mask = MASK(q->power);
  }
  q->rear = r;
/*  (q->num_elts)++; */
}

int queue_dequeue (q,d)
     queue_t q;
     ml_any_t *d;
{
  int r,s,f,s2;

  f = q->front;
  if (queue_empty(q))
    return FALSE;
  *d = (q->elts)[f];
  q->front = (f + 1) & (q->mask);
/*  (q->num_elts)--; */
  return TRUE;
}

/*
int queue_size (q)
     queue_t q;
{
  return(q->num_elts);
}
*/
