/* prim.h
 * Created 7/15/90 by David Tarditi for ML->C
 *
 * Define types of assembly language or C values to be used directly by
 * ML.
 *
 */

/* RCS log added by Nick Haines 09-Apr-93
 *
 * $Log:	prim.h,v $
 * Revision 1.3  93/04/12  15:13:02  nickh
 * Got the types wrong on msg_handoff and io_results.
 * 
 * Revision 1.2  93/04/09  18:01:08  nickh
 * Added the SML/Mach routimes msg_handoff and io_results.
 * 
 * Revision 1.1  93/04/09  17:59:41  nickh
 * SML/NJ 0.93 original.
 * 
 *
 */

#include "ml-state.h"

#ifndef _PRIM_
#define _PRIM_
extern int datalist[];
extern ml_val_t array_v[];
extern ml_val_t callc_v[];
extern ml_val_t create_b_v[];
extern ml_val_t create_r_v[];
extern ml_val_t create_s_v[];
extern ml_val_t create_v_v[];
extern ml_val_t floor_v[];
extern ml_val_t logb_v[];
extern ml_val_t scalb_v[];
extern ml_val_t try_lock_v[];
extern ml_val_t unlock_v[];
extern ml_val_t handle_v[];
extern ml_val_t msg_handoff_v[];
extern ml_val_t io_results_v[];
extern ml_val_t *return_c;
extern ml_val_t *sigh_return_c;

extern int masksigs_v[];

#ifdef C
extern int sigh_resume();
extern unsigned int Cmask;
extern int *plimit;
#else
extern int sigh_resume[];
#endif

extern ml_val_t arctan_v[],cos_v[],exp_v[],ln_v[],sin_v[],sqrt_v[];
#endif /* !_PRIM_ */
