#ifndef _ML_MACH_
#define _ML_MACH_

#include <mach_error.h>
#include <mach/message.h>
#include "ml-base.h"
#include "ml-c.h"
#include "ml-objects.h"
#include "ml-values.h"

#define MACH_DEBUG

#ifdef MACH_DEBUG
#define CHECK(ret,call)                            \
  if (((ret) = (call)) != KERN_SUCCESS) {          \
    fprintf (DebugF,"%s(%d) failed with code %d\n:",__FILE__,__LINE__,ret); \
    fprintf (DebugF,"(%s)\n", mach_error_string(ret));   \
    Die("dying\n");                                \
  } else {}
#else
#define CHECK(ret,call) ((ret) = (call))
#endif MACH_DEBUG

#define RETURN(msp,r) { \
    msp->ml_arg = (r);  \
    return;}

/* INT32_ALLOC is patterned after REC_ALLOC1 in ml-objects.h, but
   with a different descriptor. */
#define INT32_ALLOC(msp, pointer, val)	{			\
	ml_state_t	*__msp = (msp);				\
	ml_val_t	*__p = __msp->ml_allocPtr;		\
	*__p++ = MAKE_DESC(4, DTAG_string);			\
	*__p++ = (val);						\
	(pointer) = PTR_CtoML(__msp->ml_allocPtr + 1);		\
	__msp->ml_allocPtr = __p;				\
    }
	

#endif _ML_MACH
